/* teleport.js
 * Téléporte une entité vers la position et l’échelle spécifiées
 * lorsqu’un événement (app.fire(eventName)) est émis.
 */

var Teleport = pc.createScript('teleport');

// === ATTRIBUTS EXPOSÉS DANS L’ÉDITEUR ===

// Entité à téléporter (laisser vide pour this.entity)
Teleport.attributes.add('targetEntity', {
    type: 'entity',
    title: 'Target Entity',
    description: 'Entité à téléporter ; vide → entité porteuse'
});

// Nom de l’événement déclencheur
Teleport.attributes.add('eventName', {
    type: 'string',
    default: 'teleport',
    title: 'Event Name',
    description: 'Nom de l’événement qui déclenche la téléportation'
});

// Position locale cible
Teleport.attributes.add('targetPosition', {
    type: 'vec3',
    default: [0, 0, 0],
    title: 'Target Position'
});

// Échelle locale cible
Teleport.attributes.add('targetScale', {
    type: 'vec3',
    default: [1, 1, 1],
    title: 'Target Scale'
});

// === INITIALISATION ===
Teleport.prototype.initialize = function () {
    this._onTeleport = this.onTeleport.bind(this);
    this.app.on(this.eventName, this._onTeleport);
};

Teleport.prototype.destroy = function () {
    this.app.off(this.eventName, this._onTeleport);
};

// === TÉLÉPORTATION ===
Teleport.prototype.onTeleport = function () {
    var entity = this.targetEntity || this.entity;
    if (!entity) {
        console.warn('[teleport.js] Aucune entité à téléporter.');
        return;
    }

    entity.setLocalPosition(this.targetPosition);
    entity.setLocalScale(this.targetScale);
};

// === HOT‑RELOAD (PlayCanvas Editor) ===
Teleport.prototype.swap = function (old) {
    if (old && old._onTeleport) {
        this.app.off(this.eventName, old._onTeleport);
    }
};
