/* eslint-disable no-undef */
var Animator = pc.createScript('animator');

/*─────────────────────────────────────────────
 * ATTRIBUTS
 *─────────────────────────────────────────────*/
Animator.attributes.add('entitiesToAnimate', {
    type: 'entity',
    array: true,
    title: 'Entities To Animate'
});
Animator.attributes.add('triggerEvent', {
    type: 'string',
    default: 'anim:start',
    title: 'PlayCanvas Event'
});
Animator.attributes.add('playFromStart', {
    type: 'boolean',
    default: true,
    title: 'Restart From 0'
});
Animator.attributes.add('cameraToDisableName', {
    type: 'string',
    default: 'cam1',
    title: 'Camera To Disable'
});
Animator.attributes.add('cameraToEnableName', {
    type: 'string',
    default: 'animator_cam1',
    title: 'Camera To Enable'
});

/*─────────────────────────────────────────────
 * INITIALISATION
 *─────────────────────────────────────────────*/
Animator.prototype.initialize = function () {

    /* rotation helper */
    this.quat = new pc.Quat();
    const toEuler = (q) => { const v = new pc.Vec3(); q.getEulerAngles(v); return v; };

    /* TheatreJS (UI immédiatement masquée) */
    studio.initialize();
    studio.ui.hide();                          // ← UI invisible en permanence
// -- TheatreJS
//studio.initialize();

// Laisser une frame à Studio pour se monter,
// puis demander explicitement l’affichage
//requestAnimationFrame(() => studio.ui.restore());
    const state = this.app.assets.find('animation.json')?.resource;
    const proj  = getProject('anim1', { state });
    this.sheet  = proj.sheet('Main');

    const num = (v, p = 0.01) => t.number(v, { nudgeMultiplier: p });

    /* objets Theatre */
    this.entitiesToAnimate.forEach((ent) => {
        if (!ent) return;

        const pos = ent.getLocalPosition();
        const scl = ent.getLocalScale();
        const rot = toEuler(ent.getLocalRotation());

        const obj = this.sheet.object(`Entity:${ent.name}`, {
            position: { x: num(pos.x), y: num(pos.y), z: num(pos.z) },
            rotation: { x: num(rot.x), y: num(rot.y), z: num(rot.z) },
            scale:    { x: num(scl.x), y: num(scl.y), z: num(scl.z) },
            visible:  true
        });

        obj.onValuesChange((v) => this._applyTransform(ent, v));
    });

    /* déclencheur */
    this.app.on(this.triggerEvent, this._playSequence, this);

    /* raccourcis clavier (plus de touche X) */
    this.app.keyboard.on(pc.EVENT_KEYDOWN, this.onKeyDown, this);
};

Animator.prototype.destroy = function () {
    this.app.off(this.triggerEvent, this._playSequence, this);
};

/*─────────────────────────────────────────────
 * LANCE LA SÉQUENCE + switch caméras
 *─────────────────────────────────────────────*/
Animator.prototype._playSequence = function () {

    this._switchCameras();

    if (this.playFromStart) this.sheet.sequence.position = 0;
    this.sheet.sequence.play();
};

/* switch caméras */
Animator.prototype._switchCameras = function () {

    const allCams = this.app.root.findComponents('camera');
    let offOK = false, onOK = false;

    allCams.forEach((c) => {
        const e = c.entity;

        if (e.name === this.cameraToDisableName) {
            e.enabled = true; c.enabled = true; c.priority = 0;
            offOK = true;
        }
        if (e.name === this.cameraToEnableName) {
            e.enabled = true; c.enabled = true; c.priority = 9999;
            onOK = true;
        }
    });

    if (!offOK) console.warn(`Camera “${this.cameraToDisableName}” not found.`);
    if (!onOK)  console.warn(`Camera “${this.cameraToEnableName}” not found.`);
};

/* appli‑transformations */
Animator.prototype._applyTransform = function (ent, v) {

    const m = ent.model;
    if (m) v.visible ? m.show() : m.hide();

    ent.setLocalPosition(v.position.x, v.position.y, v.position.z);
    ent.setLocalScale   (v.scale.x,    v.scale.y,    v.scale.z);

    if (ent.camera) {
        ent.setEulerAngles(v.rotation.x, v.rotation.y, v.rotation.z);
    } else {
        this.quat.setFromEulerAngles(v.rotation.x, v.rotation.y, v.rotation.z);
        ent.setLocalRotation(this.quat);
    }
};

/* optionnel : toggle flyCamera actif — touche F */
Animator.prototype._toggleFlyCamera = function () {
    const cams = this.app.root.findComponents('camera');
    for (let i = 0; i < cams.length; i++) {
        const e = cams[i].entity;
        if (!e.camera.enabled) continue;
        const fly = e.script && e.script.flyCamera;
        if (!fly) return;
        fly.enabled = !fly.enabled;
        console.log('flyCamera', fly.enabled ? 'enabled' : 'disabled');
        return;
    }
};

/*─────────────────────────────────────────────
 * RACCOURCIS
 *─────────────────────────────────────────────*/
Animator.prototype.onKeyDown = function (e) {

    switch (e.key) {

        case pc.KEY_SPACE:
            this.sheet.sequence.position = 0;
            this.sheet.sequence.play();
            break;

        case pc.KEY_V:
            const json = studio.createContentOfSaveFile('scene1');
            navigator.clipboard.writeText(JSON.stringify(json));
            alert('JSON copied to clipboard!');
            break;

        case pc.KEY_F:
            this._toggleFlyCamera();
            break;
    }
};
