var UpAndDown = pc.createScript('upAndDown');

// Déclare les attributs
UpAndDown.attributes.add('amplitude', {
    type: 'number',
    default: 1,
    title: 'Amplitude',
    description: 'Hauteur de l’oscillation'
});

UpAndDown.attributes.add('frequency', {
    type: 'number',
    default: 1,
    title: 'Fréquence',
    description: 'Vitesse de l’oscillation'
});

// L’initialize se lance une seule fois quand le script démarre
UpAndDown.prototype.initialize = function () {
    // Position de départ sur l’axe Y
    this.startingY = this.entity.getLocalPosition().y;

    // Stockage du temps pour la sinusoïde
    this.time = 0;
};

// L’update est appelé à chaque frame
UpAndDown.prototype.update = function (dt) {
    this.time += dt;

    // On récupère la position locale
    var pos = this.entity.getLocalPosition();

    // On modifie le Y avec la fonction sinus
    pos.y = this.startingY + Math.sin(this.time * this.frequency) * this.amplitude;

    // On réapplique la position
    this.entity.setLocalPosition(pos);
};
