var RandomMaterialOffset = pc.createScript('randomMaterialOffset');

RandomMaterialOffset.prototype.initialize = function() {
    var meshInstances = this.entity.render.meshInstances;

    meshInstances.forEach(function(meshInstance) {
        // Exemple avec la texture diffuse (adapte selon tes besoins)
        var offsetX = Math.random();
        var offsetY = Math.random();

        // Transform0 contrôle échelle X (tileWidth) et offset X
        var transform0 = [1, 0, offsetX]; // 1 = échelle normale sur X, 0 rotation implicite, offsetX
        // Transform1 contrôle échelle Y (tileHeight) et offset Y
        var transform1 = [0, 1, offsetY]; // 1 = échelle normale sur Y, 0 rotation implicite, offsetY

        meshInstance.setParameter('texture_diffuseMapTransform0', transform0);
        meshInstance.setParameter('texture_diffuseMapTransform1', transform1);

        // Si tu veux aussi appliquer aux autres maps (emissive, normal, etc.), fais pareil :
        meshInstance.setParameter('texture_emissiveMapTransform0', transform0);
        meshInstance.setParameter('texture_emissiveMapTransform1', transform1);

        meshInstance.setParameter('texture_normalMapTransform0', transform0);
        meshInstance.setParameter('texture_normalMapTransform1', transform1);

        // Ajoute les autres maps si nécessaire (metalnessMap, glossMap, etc.)
    });
};