var Musique = pc.createScript('musique');

/**
 * Propriété pour spécifier le nom de l'événement déclencheur
 * que vous utiliserez pour lancer la musique (depuis l'éditeur).
 */
Musique.attributes.add('eventName', {
    type: 'string',
    default: 'musiqueStart',
    title: 'Nom de l\'événement déclencheur'
});

/**
 * Propriété pour spécifier le nom du slot audio à jouer.
 * Si vous n'avez qu'un seul slot, vous pouvez laisser cette
 * case vide et "this.soundComponent.play()" jouera automatiquement le premier slot.
 */
Musique.attributes.add('soundSlotName', {
    type: 'string',
    default: '',
    title: 'Nom du slot audio (laisser vide si un seul slot)'
});

Musique.prototype.initialize = function() {
    // Vérifier si l'entité a bien un composant "sound"
    if (!this.entity.sound) {
        console.warn("L'entité n'a pas de composant 'sound'. Assurez-vous que l'entité 'musique' possède un composant 'sound'.");
        return;
    }

    this.soundComponent = this.entity.sound;

    // Écouter l'événement dont le nom est défini dans la propriété 'eventName'
    this.app.on(this.eventName, this.onMusiqueStart, this);
};

Musique.prototype.onMusiqueStart = function() {
    // Vérifie si ce composant "sound" est déjà en train de jouer quelque chose
    if (!this.soundComponent.playing) {
        // S'il y a un nom de slot défini, on joue ce slot.
        // Sinon, on joue le premier slot (ou le seul) du composant sound.
        if (this.soundSlotName && this.soundSlotName.trim() !== '') {
            this.soundComponent.play(this.soundSlotName);
        } else {
            this.soundComponent.play();
        }
    }
};
