var SwitchToBarCam = pc.createScript('switchToBarCam');

// Attribut pour désigner facilement la caméra cible "barCam"
SwitchToBarCam.attributes.add('barCam', {
    type: 'entity',
    title: 'Caméra cible (barCam)'
});

SwitchToBarCam.prototype.initialize = function() {
    if (!this.barCam || !this.barCam.camera) {
        console.error("[SwitchToBarCam] barCam non définie ou sans composant caméra !");
        return;
    }

    this.app.on('barcamAnim', this.switchCam, this);

    this.on('destroy', function () {
        this.app.off('barcamAnim', this.switchCam, this);
    }, this);
};

SwitchToBarCam.prototype.switchCam = function() {
    // Désactive cette caméra (introCam)
    this.entity.enabled = false;

    // Active la caméra cible (barCam)
    this.barCam.enabled = true;

    console.log("[SwitchToBarCam] Passage à la caméra :", this.barCam.name);
};
