var BloomActiveCamera = pc.createScript('bloomActiveCamera');

/**
 * Attributs pour configurer l'effet Bloom
 */
BloomActiveCamera.attributes.add('bloomIntensity', {
    type: 'number', default: 1.25, min: 0, title: 'Intensity'
});
BloomActiveCamera.attributes.add('bloomThreshold', {
    type: 'number', default: 0.25, min: 0, max: 1, title: 'Threshold'
});
BloomActiveCamera.attributes.add('blurAmount', {
    type: 'number', default: 4, min: 1, title: 'Blur amount'
});

/**
 * INITIALISATION
 */
BloomActiveCamera.prototype.initialize = function() {
    // 1) Trouver toutes les caméras de la scène
    var cameraComponents = this.app.root.findComponents('camera');
    if (!cameraComponents || cameraComponents.length === 0) {
        console.warn("Aucune caméra trouvée dans la scène.");
        return;
    }

    // 2) Filtrer seulement celles qui sont "enabled"
    var enabledCameras = cameraComponents.filter(function(cam) {
        return cam.entity.enabled;
    });

    if (enabledCameras.length === 0) {
        console.warn("Aucune caméra active (enabled) dans la scène.");
        return;
    }

    // 3) Trouver la caméra ayant la plus haute "priority"
    //    => c'est probablement la caméra "active"
    var bestCamComp = enabledCameras[0];
    for (var i = 1; i < enabledCameras.length; i++) {
        if (enabledCameras[i].priority > bestCamComp.priority) {
            bestCamComp = enabledCameras[i];
        }
    }

    // bestCamComp devrait être la caméra la plus prioritaire
    this._activeCameraComp = bestCamComp;
    this._cameraEntity = bestCamComp.entity;

    // 4) Créer et configurer l'instance de BloomEffect
    this.effect = new BloomEffect(this.app.graphicsDevice);

    this.effect.bloomThreshold = this.bloomThreshold;
    this.effect.blurAmount     = this.blurAmount;
    this.effect.bloomIntensity = this.bloomIntensity;

    // 5) L'ajouter à la queue de postEffects de cette caméra
    this._activeCameraComp.postEffects.addEffect(this.effect);

    console.log("Bloom ajouté sur la caméra: " + this._cameraEntity.name);
};

/**
 * Nettoyage quand le script est détruit ou désactivé
 */
BloomActiveCamera.prototype.destroy = function() {
    this.removeBloom();
};

BloomActiveCamera.prototype.removeBloom = function() {
    if (this.effect && this._activeCameraComp) {
        this._activeCameraComp.postEffects.removeEffect(this.effect);
        // détruire le BloomEffect si besoin
        if (this.effect._destroy) {
            this.effect._destroy();
        }
        this.effect = null;
    }
};
