var Cam2Move = pc.createScript('cam2Move');

// Attributs pour régler la vitesse de déplacement et les paramètres des mouvements de tête
Cam2Move.attributes.add('speed', { type: 'number', default: 5, title: 'Vitesse de Déplacement' });
Cam2Move.attributes.add('headTurnFrequency', { type: 'number', default: 3, title: 'Fréquence des Coups de Tête (s)' });
Cam2Move.attributes.add('headTurnAngle', { type: 'number', default: 30, title: 'Angle des Coups de Tête (degrés)' });
Cam2Move.attributes.add('returnSpeed', { type: 'number', default: 0.1, title: 'Vitesse de Retour de la Tête' });

// Variable pour stocker la position initiale de la tête (angle de vue)
Cam2Move.prototype.initialize = function() {
    this.elapsedTime = 0;
    this.turnDirection = 1; // 1 pour droite, -1 pour gauche
    this.currentHeadAngle = 0;
    this.headEntity = this.entity.findByName("Head"); // Trouve la sous-entité caméra nommée "Head"
};

// Mise à jour à chaque frame
Cam2Move.prototype.update = function(dt) {
    // Avancer tout droit sans changer la rotation de l'entité principale
    this.entity.translateLocal(0, 0, this.speed * dt);

    // Mise à jour du temps écoulé
    this.elapsedTime += dt;

    // Vérification de la nécessité de tourner la tête
    if (this.elapsedTime >= this.headTurnFrequency) {
        this.turnDirection *= -1; // Changer de direction
        this.elapsedTime = 0; // Réinitialiser le compteur de temps
    }

    // Calcul de l'angle de rotation de la tête
    if (this.elapsedTime < this.headTurnFrequency / 2) {
        // Tourner la tête vers l'angle maximal
        this.currentHeadAngle = pc.math.lerp(this.currentHeadAngle, this.headTurnAngle * this.turnDirection, this.returnSpeed);
    } else {
        // Ramener la tête vers 0 degré
        this.currentHeadAngle = pc.math.lerp(this.currentHeadAngle, 0, this.returnSpeed);
    }

    // Appliquer la rotation de la tête
    if (this.headEntity) {
        this.headEntity.setLocalEulerAngles(0, this.currentHeadAngle, 0);
    }
};
