var DisableByTags = pc.createScript('disableByTags');

/**
 * Nom de l'évènement à écouter pour désactiver les entités.
 * Laissez-le vide si vous souhaitez que la désactivation
 * se fasse immédiatement dans la fonction initialize().
 */
DisableByTags.attributes.add('eventName', {
    type: 'string',
    default: '',
    title: 'Nom de l\'évènement'
});

/**
 * Liste de tags à désactiver.
 * Toutes les entités portant un de ces tags seront désactivées.
 */
DisableByTags.attributes.add('tagsToDisable', {
    type: 'string',
    array: true,
    title: 'Tags à désactiver'
});

// Appelé une fois au démarrage
DisableByTags.prototype.initialize = function() {
    // Si un nom d'évènement est spécifié, on s'abonne
    if (this.eventName) {
        this.app.on(this.eventName, this.onDisableByTags, this);
    } else {
        // Sinon, on désactive immédiatement
        this.onDisableByTags();
    }
};

// Méthode qui désactive toutes les entités portant les tags
DisableByTags.prototype.onDisableByTags = function() {
    // Pour chaque tag présent dans la liste
    for (var i = 0; i < this.tagsToDisable.length; i++) {
        var tag = this.tagsToDisable[i];
        
        // Récupère toutes les entités qui possèdent ce tag
        var entities = this.app.root.findByTag(tag);
        
        // Désactive chaque entité concernée
        for (var j = 0; j < entities.length; j++) {
            entities[j].enabled = false;
        }
    }
};

// Se désabonner de l'évènement si le script est détruit
DisableByTags.prototype.destroy = function() {
    if (this.eventName) {
        this.app.off(this.eventName, this.onDisableByTags, this);
    }
};
