// Nom du script : particleTrigger.js

var ParticleTrigger = pc.createScript('particleTrigger');

/**
 * Entité contenant le composant ParticleSystem
 */
ParticleTrigger.attributes.add('particleEntity', {
    type: 'entity',
    title: 'Particle Entity',
    description: 'Entité qui contient le composant ParticleSystem'
});

/**
 * Nom de l'événement pour démarrer les particules
 * - Exemple : "demarrer:particules"
 */
ParticleTrigger.attributes.add('startEventName', {
    type: 'string',
    default: 'demarrer:particules',
    title: 'Événement de démarrage',
    description: 'Nom de l\'événement écouté pour démarrer les particules'
});

/**
 * Nom de l'événement pour stopper les particules (optionnel)
 * - Exemple : "arreter:particules"
 * - Laissez vide si vous ne voulez pas gérer l'arrêt par un événement
 */
ParticleTrigger.attributes.add('stopEventName', {
    type: 'string',
    default: '',
    title: 'Événement d\'arrêt',
    description: 'Nom de l\'événement écouté pour stopper les particules (optionnel)'
});

ParticleTrigger.prototype.initialize = function() {
    // S'assure que l'entité de particules est bien désactivée ou non.
    // Si vous ne voulez pas la désactiver automatiquement, commentez cette ligne :
    if (this.particleEntity) {
        this.particleEntity.enabled = false;
    }

    // Écoute l'événement de démarrage s'il est défini
    if (this.startEventName && this.startEventName.trim() !== '') {
        this.app.on(this.startEventName, this.onStartParticles, this);
    }
    
    // Écoute l'événement d'arrêt s'il est défini
    if (this.stopEventName && this.stopEventName.trim() !== '') {
        this.app.on(this.stopEventName, this.onStopParticles, this);
    }
};

/**
 * Callback appelé lors de l'événement de démarrage
 */
ParticleTrigger.prototype.onStartParticles = function() {
    if (this.particleEntity && this.particleEntity.particlesystem) {
        // Active l'entité si elle est désactivée
        this.particleEntity.enabled = true;
        // Réinitialise le système de particules pour rejouer depuis le début
        this.particleEntity.particlesystem.reset();
        // Joue l'effet
        this.particleEntity.particlesystem.play();
    }
};

/**
 * Callback appelé lors de l'événement d'arrêt (si défini)
 */
ParticleTrigger.prototype.onStopParticles = function() {
    if (this.particleEntity && this.particleEntity.particlesystem) {
        // Stoppe l'effet. (Laissez "stop()" si vous voulez juste stopper l'émission,
        // ou utilisez "reset()" pour tout réinitialiser, selon votre besoin.)
        this.particleEntity.particlesystem.stop();
        
        // Si vous voulez totalement désactiver l’entité après l’arrêt (au lieu de la laisser affichée), vous pouvez faire :
        // this.particleEntity.enabled = false;
    }
};
