function Supernova2Effect(graphicsDevice) {
    pc.PostEffect.call(this, graphicsDevice);

    // On stocke le temps et la position camera (2D)
    this.time = 0;
    this.camPos = new pc.Vec2(0, 0);

    // Valeur de fade (entre 0 et 1)
    this.fade = 0;

    // Le shader
    const fshader = /* glsl */ `
        #define BURST
        #define NUM_LAYERS 5.0

        mat2 Rot(float a) {
            float s = sin(a), c = cos(a);
            return mat2(c,-s,s,c);
        }

        float Star(vec2 uv, float a, float sparkle) {
            vec2 av1 = abs(uv);
            vec2 av2 = abs(uv * Rot(a));
            vec2 av = min(av1, av2);

            float d = length(uv);
            float star = max(av1.x*av1.y, av2.x*av2.y);
            star = max(0.0, 1.0 - star*1e3);
            float m = min(5.0, 1e-2/d);
            return m + pow(star, 4.0)*sparkle;
        }

        float Hash21(vec2 p) {
            p = fract(p*vec2(123.34,145.54));
            p += dot(p, p+45.23);
            return fract(p.x*p.y);
        }

        vec3 StarLayer(vec2 uv, float t, float sparkle) {
            vec2 gv = fract(uv) - 0.5;
            vec2 id = floor(uv);
            vec3 col = vec3(0.0);

            #ifndef BURST
            t = 0.0;
            #endif

            // on échantillonne 9 cellules voisines
            for(int y=-1; y<=1; y++) {
                for(int x=-1; x<=1; x++) {
                    vec2 offs = vec2(x, y);
                    float n = Hash21(id - offs);
                    vec3 N = fract(n * vec3(10.0,100.0,1000.0));
                    vec2 p = (N.xy - 0.5)*0.7;

                    float brightness = Star(gv - p + offs, n*6.2831 + t, sparkle);
                    vec3 star = brightness * vec3(0.6 + p.x, 0.4, 0.6 + p.y) * N.z * N.z;

                    // scintillement
                    star *= 1.0 + sin((t+n)*20.0)*smoothstep(sin(t)*0.5+0.5, 1.0, fract(10.0*n));

                    float d = length(gv + offs);
                    col += star * smoothstep(1.5, 0.8, d);
                }
            }
            return col;
        }

        // Uniformes PlayCanvas
        varying vec2 vUv0;
        uniform sampler2D uColorBuffer; // la scène
        uniform float uTime;
        uniform vec2  uResolution;
        uniform vec2  uCamPos;
        uniform float uFade;           // <-- Pour le fondu !

        void main() {
            // Récupère la scène
            vec4 sceneColor = texture2D(uColorBuffer, vUv0);

            // On reconstruit fragCoord 
            vec2 fragCoord = vUv0 * uResolution;
            vec2 uv = (fragCoord - 0.5*uResolution)/uResolution.y;

            float t = -uTime*0.3;

            float twirl = sin(t*0.1);
            twirl = twirl*twirl*twirl*sin(dot(uv,uv));
            uv *= Rot(-t*0.2);

            uv *= (2.0 + sin(t*0.05));

            vec3 col = vec3(0.0);
            float speed = -0.2;

            #ifdef BURST
            speed = 0.1;
            float bla = sin(t + sin(t + sin(t)*0.5))*0.5 + 0.5;
            float d = dot(uv, uv);
            float a = atan(uv.x, uv.y);
            uv /= d; 
            float burst = sin(uTime*0.05);
            uv *= burst + 0.2;
            #endif

            // on ajoute un offset pour simuler la caméra
            float stp = 1.0/NUM_LAYERS;

            for(float i=0.0; i<1.0; i+=stp) {
                float lt = fract(t*speed + i);
                float scale = mix(10.0, 0.25, lt);
                float fade = smoothstep(0.0, 0.4, lt)*smoothstep(1.0, 0.95, lt);

                vec2 sv = uv*scale + i*134.53 - uCamPos; 
                col += StarLayer(sv, t, fade)*fade;
            }

            #ifdef BURST
            float burstFade = smoothstep(0.0, 0.02, abs(burst));
            float size = 0.9*sin(uTime*0.5) + 1.0;
            size = max(size, sqrt(size));
            float fade = size/d;
            col *= mix(1.0, fade, burstFade);
            col += fade*0.2*vec3(1.0,0.5,0.1)*bla*burstFade;

            float t2 = uTime*0.5;
            a -= uCamPos.x*0.1;
            float rays = sin(a*5.0 + t2*3.0) - cos(a*7.0 - t2);
            rays *= sin(a + t2 + sin(a*4.0)*10.0)*0.5 + 0.5;
            col += rays*bla*0.1*burstFade;

            // on rajoute "1.0 - burstFade" pour des aspects stylisés,
            // vous pouvez ajuster ou retirer si besoin
         col += (1.0 - burstFade) * uFade;
            #else
            col *= 4.0;
            #endif

            // === FONDU ===
            // on mélange additivement, modulé par uFade
            vec3 finalColor = sceneColor.rgb + col * uFade;

            gl_FragColor = vec4(finalColor, 1.0);
        }
    `;

    this.shader = pc.createShaderFromCode(
        graphicsDevice,
        pc.PostEffect.quadVertexShader,
        fshader,
        "Supernova2ShaderAdd",
        { aPosition: pc.SEMANTIC_POSITION }
    );
}

Supernova2Effect.prototype = Object.create(pc.PostEffect.prototype);
Supernova2Effect.prototype.constructor = Supernova2Effect;

Object.assign(Supernova2Effect.prototype, {
    render: function (inputTarget, outputTarget, rect) {
        const scope = this.device.scope;

        // On passe la scène
        scope.resolve("uColorBuffer").setValue(inputTarget.colorBuffer);

        // On passe la résolution
        scope.resolve("uResolution").setValue([this.device.width, this.device.height]);

        // On passe time, camPos, et le fade
        scope.resolve("uTime").setValue(this.time);
        scope.resolve("uCamPos").setValue(this.camPos.data);
        scope.resolve("uFade").setValue(this.fade);

        // on dessine
        this.drawQuad(outputTarget, this.shader, rect);
    }
});
