var Supernova2 = pc.createScript('supernova2');

/**
 * ATTRIBUTS
 */
// Nom de l’événement qui déclenchera l’activation du post-effect
Supernova2.attributes.add('triggerEventName', {
    type: 'string',
    default: 'supernova2',
    title: 'Event to Enable Supernova2',
    description: 'Nom de l’événement qui activera ce post-effect'
});

// Vitesse d’animation du temps
Supernova2.attributes.add('speed', {
    type: 'number',
    default: 1,
    title: 'Animation Speed'
});

// Facteur d’échelle pour convertir la position 3D en offset 2D
Supernova2.attributes.add('posScale', {
    type: 'number',
    default: 5,
    title: 'Position Scale'
});

// Vitesse du fondu d’entrée
Supernova2.attributes.add('fadeInSpeed', {
    type: 'number',
    default: 1,
    title: 'Fade In Speed'
});

/**
 * INITIALISATION
 */
Supernova2.prototype.initialize = function() {
    // 1) Créer l'instance du post-effect (mais ne pas l'ajouter)
    this.effect = new Supernova2Effect(this.app.graphicsDevice);

    // 2) Récupérer la "queue" de postEffects associée à la caméra
    this.queue = this.entity.camera.postEffects;

    // 3) État interne pour savoir si l’effet est déjà activé
    this._effectAdded = false;

    // 4) On écoute l’événement "triggerEventName"
    if (this.triggerEventName) {
        this.app.on(this.triggerEventName, this.enableSupernova2Effect, this);
    }

    // 5) Activation / désactivation du script
    this.on('state', function(enabled) {
        if (!enabled) {
            // Si on désactive le script, on retire l’effet
            this.disableSupernova2Effect(false);
        } else {
            // Si on réactive le script et que l’effet a déjà été déclenché, on le remet
            if (this._effectAdded) {
                this.enableSupernova2Effect();
            }
        }
    });

    // 6) Nettoyage lorsque l'entité est détruite
    this.on('destroy', function() {
        // Retire l’effet et détruit si besoin
        this.disableSupernova2Effect(true);
    });
};

/**
 * UPDATE (chaque frame)
 */
Supernova2.prototype.update = function(dt) {
    // Si l’effet n’est pas activé, on ne fait rien
    if (!this._effectAdded) {
        return;
    }

    // 1) Avancement du temps
    this.effect.time += dt * this.speed;

    // 2) Gère le fondu d’entrée (si fade < 1, on l’incrémente)
    if (this.effect.fade < 1) {
        this.effect.fade += dt * this.fadeInSpeed;
        if (this.effect.fade > 1) {
            this.effect.fade = 1;
        }
    }

    // 3) On récupère la position 3D de l’entité (ex: la caméra)
    var pos = this.entity.getPosition();
    // Conversion en offset 2D
    this.effect.camPos.set(pos.x * this.posScale, pos.z * this.posScale);
};


/**
 * MÉTHODES PERSONNALISÉES
 */

// Active l’effet Supernova2 si le script est enabled
Supernova2.prototype.enableSupernova2Effect = function() {
    if (!this.enabled) return;

    // Réinitialise le fade (pour redémarrer le fondu d’entrée)
    this.effect.fade = 0;

    // Ajoute l’effet si pas déjà présent
    if (!this._effectAdded) {
        this.queue.addEffect(this.effect);
        this._effectAdded = true;
        console.log("supernova added")
    }
};

// Désactive l’effet
// Param. destroy=true => détruit l’effet
Supernova2.prototype.disableSupernova2Effect = function(destroy) {
    if (this._effectAdded) {
        this.queue.removeEffect(this.effect);
        this._effectAdded = false;
    }
    if (destroy && this.effect._destroy) {
        this.effect._destroy();
    }
};
