// --------------- POST EFFECT DEFINITION --------------- //
function BokehEffect(graphicsDevice) {
    pc.PostEffect.call(this, graphicsDevice);

    this.needsDepthBuffer = true;

    // Shader auteur: alteredq / http://alteredqualia.com/
    // (porté depuis un code GLSL original par Martins Upitis)
    var fshader = [
        pc.shaderChunks.screenDepthPS,
        "",
        "varying vec2 vUv0;",
        "",
        "uniform sampler2D uColorBuffer;",
        "",
        "uniform float uMaxBlur;",  // max blur amount
        "uniform float uAperture;", // bigger values => shallower DOF
        "uniform float uFocus;",
        "uniform float uAspect;",
        "",
        "void main() {",
        "    vec2 aspectCorrect = vec2(1.0, uAspect);",
        "",
        "    float factor = ( (getLinearScreenDepth(vUv0) * -1.0) - uFocus ) / camera_params.y;",
        "    vec2 dofblur = vec2(clamp(factor * uAperture, -uMaxBlur, uMaxBlur));",
        "",
        "    vec2 dofblur9 = dofblur * 0.9;",
        "    vec2 dofblur7 = dofblur * 0.7;",
        "    vec2 dofblur4 = dofblur * 0.4;",
        "",
        "    vec4 col;",
        "    col  = texture2D(uColorBuffer, vUv0);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.0,   0.4 ) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.15,  0.37) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.29,  0.29) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.37,  0.15) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.40,  0.0 ) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.37, -0.15) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.29, -0.29) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.15, -0.37) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.0,  -0.4 ) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.15,  0.37) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.29,  0.29) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.37,  0.15) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.4,   0.0 ) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.37, -0.15) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.29, -0.29) * aspectCorrect) * dofblur);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.15, -0.37) * aspectCorrect) * dofblur);",
        "",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.15,  0.37) * aspectCorrect) * dofblur9);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.37,  0.15) * aspectCorrect) * dofblur9);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.37, -0.15) * aspectCorrect) * dofblur9);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.15, -0.37) * aspectCorrect) * dofblur9);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.15,  0.37) * aspectCorrect) * dofblur9);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.37,  0.15) * aspectCorrect) * dofblur9);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.37, -0.15) * aspectCorrect) * dofblur9);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.15, -0.37) * aspectCorrect) * dofblur9);",
        "",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.29,  0.29) * aspectCorrect) * dofblur7);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.40,  0.0 ) * aspectCorrect) * dofblur7);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.29, -0.29) * aspectCorrect) * dofblur7);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.0,  -0.4 ) * aspectCorrect) * dofblur7);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.29,  0.29) * aspectCorrect) * dofblur7);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.4,   0.0 ) * aspectCorrect) * dofblur7);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.29, -0.29) * aspectCorrect) * dofblur7);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.0,   0.4 ) * aspectCorrect) * dofblur7);",
        "",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.29,  0.29) * aspectCorrect) * dofblur4);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.4,   0.0 ) * aspectCorrect) * dofblur4);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.29, -0.29) * aspectCorrect) * dofblur4);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.0,  -0.4 ) * aspectCorrect) * dofblur4);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.29,  0.29) * aspectCorrect) * dofblur4);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.4,   0.0 ) * aspectCorrect) * dofblur4);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2(-0.29, -0.29) * aspectCorrect) * dofblur4);",
        "    col += texture2D(uColorBuffer, vUv0 + (vec2( 0.0,   0.4 ) * aspectCorrect) * dofblur4);",
        "",
        "    gl_FragColor = col / 41.0;",
        "    gl_FragColor.a = 1.0;",
        "}"
    ].join("\n");

    this.shader = pc.createShaderFromCode(graphicsDevice, pc.PostEffect.quadVertexShader, fshader, 'BokehShader', {
        aPosition: pc.SEMANTIC_POSITION
    });

    // Uniforms
    this.maxBlur = 0.02;
    this.aperture = 1;
    this.focus = 1;
}
BokehEffect.prototype = Object.create(pc.PostEffect.prototype);
BokehEffect.prototype.constructor = BokehEffect;

Object.assign(BokehEffect.prototype, {
    render: function (inputTarget, outputTarget, rect) {
        var device = this.device;
        var scope = device.scope;

        scope.resolve("uMaxBlur").setValue(this.maxBlur);
        scope.resolve("uAperture").setValue(this.aperture);
        scope.resolve("uFocus").setValue(this.focus);
        scope.resolve("uAspect").setValue(device.width / device.height);
        scope.resolve("uColorBuffer").setValue(inputTarget.colorBuffer);

        this.drawQuad(outputTarget, this.shader, rect);
    }
});

// ----------------- SCRIPT DEFINITION ------------------ //
var Bokeh = pc.createScript('bokeh');

/**
 *  ATTRIBUTS
 */
Bokeh.attributes.add('enableEvent', {
    type: 'string',
    default: 'enableBokeh',
    title: 'Enable Event',
    description: 'Nom de l’événement qui active ce post-effect'
});

Bokeh.attributes.add('disableEvent', {
    type: 'string',
    default: '',
    title: 'Disable Event (optionnel)',
    description: 'Nom de l’événement qui désactive le post-effect (optionnel)'
});

Bokeh.attributes.add('maxBlur', {
    type: 'number',
    default: 0.02,
    min: 0,
    max: 1,
    title: 'Max Blur'
});

Bokeh.attributes.add('aperture', {
    type: 'number',
    default: 1,
    min: 0,
    max: 1,
    title: 'Aperture'
});

Bokeh.attributes.add('focus', {
    type: 'number',
    default: 1,
    title: 'Focus'
});

/**
 * INITIALISE
 */
Bokeh.prototype.initialize = function () {
    // On crée l’effet
    this.effect = new BokehEffect(this.app.graphicsDevice);

    // Applique les valeurs initiales
    this.effect.maxBlur  = this.maxBlur;
    this.effect.aperture = this.aperture;
    this.effect.focus    = this.focus;

    // Pour écouter les changements d’attributs dans l’éditeur
    this.on('attr', function (name, value) {
        if (this.effect && this.effect.hasOwnProperty(name)) {
            this.effect[name] = value;
        }
    }, this);

    // Récupère la file de postEffects de la caméra
    this.queue = this.entity.camera.postEffects;

    // Indique si on a déjà ajouté l’effet
    this._effectActive = false;

    // Écoute des événements
    if (this.enableEvent) {
        this.app.on(this.enableEvent, this.enableBokeh, this);
    }
    if (this.disableEvent && this.disableEvent.length > 0) {
        this.app.on(this.disableEvent, this.disableBokeh, this);
    }

    // Gère l’activation/désactivation du script
    this.on('state', function(enabled) {
        // Si le script se désactive, on retire l’effet
        if (!enabled) {
            this.disableBokeh();
        } else {
            // Si on le réactive et qu’on avait déjà l’effet actif,
            // on le remet
            if (this._effectActive) {
                this.enableBokeh();
            }
        }
    });

    // Nettoyage au destroy
    this.on('destroy', function() {
        this.disableBokeh(true);
    });
};

/**
 * MÉTHODES PERSONNALISÉES
 */
// Active l’effet, si le script est enabled
Bokeh.prototype.enableBokeh = function() {
    if (!this.enabled) return;
    if (!this._effectActive) {
        this.queue.addEffect(this.effect);
        this._effectActive = true;
    }
};

// Désactive l’effet
// Si 'destroy' == true, on détruit définitivement l’effet
Bokeh.prototype.disableBokeh = function(destroy) {
    if (this._effectActive) {
        this.queue.removeEffect(this.effect);
        this._effectActive = false;
    }
    if (destroy && this.effect && this.effect._destroy) {
        this.effect._destroy();
    }
};
