var RotateEntity = pc.createScript('rotateEntity');

// Ajoute des attributs pour configurer la rotation
RotateEntity.attributes.add('rotationSpeed', {
    type: 'vec3',
    default: [0, 30, 0],
    title: 'Vitesse de rotation',
    description: 'Vitesse de rotation en degrés par seconde (x, y, z)'
});

RotateEntity.attributes.add('useLocalRotation', {
    type: 'boolean',
    default: true,
    title: 'Utiliser rotation locale',
    description: 'Si activé, rotate dans le repère local, sinon dans le repère monde'
});

// Mise à jour à chaque frame
RotateEntity.prototype.update = function(dt) {
    // Calculer la rotation à appliquer basée sur la vitesse et le temps écoulé
    var rotationX = this.rotationSpeed.x * dt;
    var rotationY = this.rotationSpeed.y * dt;
    var rotationZ = this.rotationSpeed.z * dt;
    
    if (this.useLocalRotation) {
        // Rotation dans l'espace local de l'entité
        this.entity.rotateLocal(rotationX, rotationY, rotationZ);
    } else {
        // Rotation dans l'espace monde
        this.entity.rotate(rotationX, rotationY, rotationZ);
    }
};