var SimpleShader = pc.createScript('simpleShader');

SimpleShader.attributes.add('vs', {
    type: 'asset',
    assetType: 'shader',
    title: 'Vertex Shader'
});

SimpleShader.attributes.add('fs', {
    type: 'asset',
    assetType: 'shader',
    title: 'Fragment Shader'
});

SimpleShader.attributes.add('speed', {
    type: 'number',
    default: 1.0,
    title: 'Speed'
});

SimpleShader.attributes.add('materials', {
    type: 'asset',
    assetType: 'material',
    array: true,
    title: 'Materials'
});

// initialize code called once per entity
SimpleShader.prototype.initialize = function() {
    this.time = 0;

    var app = this.app;
    var gd = app.graphicsDevice;

    var fragmentShader = this.fs.resource;

    // update all the materials with the chunk
    for (var i = 0; i < this.materials.length; i++) {
        var material = this.materials[i].resource;
        material.chunks.APIVersion = pc.CHUNKAPI_1_57;
        material.chunks.emissivePS = fragmentShader;

        // Force the shader generator to generate UV processing code
        material.diffuseMap = new pc.Texture(this.app.graphicsDevice, {
            width: 1,
            height: 1,
            format: pc.PIXELFORMAT_R8_G8_B8
        });

        // Set default light parameters
        var lightEntity = app.root.findByName('Light');
        if (lightEntity && lightEntity.light) {
            var light = lightEntity.light;
            var lightDirection = lightEntity.forward.clone().normalize().data;
            var lightColor = light.color.data;
            var ambientColor = app.scene.ambientLight.data;

            material.setParameter('uLightDirection', lightDirection);
            material.setParameter('uLightColor', lightColor);
            material.setParameter('uAmbientColor', ambientColor);

            if (light.castShadows) {
                if (light.shadowMap) {
                    material.setParameter('uShadowMap', light.shadowMap);
                } else {
                    console.warn("The light is set to cast shadows but has no shadow map.");
                }
                if (light.shadowMatrix) {
                    material.setParameter('uLightMatrix', light.shadowMatrix.data);
                } else {
                    console.warn("The light does not have a shadow matrix.");
                }
            } else {
                console.warn("The light is not set to cast shadows.");
            }
        } else {
            console.warn("Light entity not found or it does not have a light component.");
        }

        material.update();
    }

    window.onresize = function(event) {
        for (var i = 0; i < this.materials.length; i++) {
            var material = this.materials[i].resource;
            material.setParameter("iResolution", new pc.Vec3(this.app.graphicsDevice.width, this.app.graphicsDevice.height, 0.0).data);
        }
    }.bind(this);

    this.materials.forEach(function(materialAsset) {
        var material = materialAsset.resource;
        material.setParameter('iResolution', new pc.Vec3(app.graphicsDevice.width, app.graphicsDevice.height, 0.0).data);
    });
};

// update code called every frame
SimpleShader.prototype.update = function(dt) {
    this.time += dt * this.speed;  // Adjust time based on speed

    // Update the time value in the material
    for (var i = 0; i < this.materials.length; i++) {
        var material = this.materials[i].resource;
        material.setParameter('time', this.time);
    }
};
