attribute vec3 aPosition;
attribute vec3 aNormal;
attribute vec2 aUv0;

uniform mat4 matrix_model;
uniform mat4 matrix_viewProjection;
uniform mat3 matrix_normal;
uniform mat4 matrix_lightViewProjection;

varying vec3 vNormal;
varying vec2 vUv;
varying vec3 vPosition;
varying vec2 vUv0;
varying vec4 vLightCoord;

void main(void) {
    vNormal = normalize(matrix_normal * aNormal);
    vUv0 = aUv0;
    vPosition = (matrix_model * vec4(aPosition, 1.0)).xyz;
    vLightCoord = matrix_lightViewProjection * vec4(vPosition, 1.0);
    gl_Position = matrix_viewProjection * vec4(vPosition, 1.0);
}
