#define HALF_PI 1.5707963267948966  // Pi / 2
#define PI 3.14159265358979323846   // Pi
#define TWO_PI 6.28318530717958647692  // 2 * Pi

vec3 rot(vec3 vertex, vec3 angles) {
    // Angles in radians
    float cx = cos(angles.x); // Cosine of the angle around the X axis
    float sx = sin(angles.x); // Sine of the angle around the X axis
    float cy = cos(angles.y); // Cosine of the angle around the Y axis
    float sy = sin(angles.y); // Sine of the angle around the Y axis
    float cz = cos(angles.z); // Cosine of the angle around the Z axis
    float sz = sin(angles.z); // Sine of the angle around the Z axis

    // Rotation matrix for the X axis
    mat3 rotX = mat3(
        1.0, 0.0,  0.0,
        0.0,  cx, -sx,
        0.0,  sx,  cx
    );

    // Rotation matrix for the Y axis
    mat3 rotY = mat3(
         cy, 0.0, sy,
         0.0, 1.0, 0.0,
        -sy, 0.0, cy
    );

    // Rotation matrix for the Z axis
    mat3 rotZ = mat3(
         cz, -sz, 0.0,
         sz,  cz, 0.0,
         0.0, 0.0, 1.0
    );

    // Apply rotations in the order: X -> Y -> Z
    return rotZ * rotY * rotX * vertex;
}


vec3 radial(vec3 cartesian) {
    // Radius: distance from the origin
    float radius = length(cartesian);

    // Azimuthal angle (φ): angle around the Z-axis (in the XY-plane)
    float azimuth = atan(cartesian.y, cartesian.x);

    // Polar angle (θ): angle from the Z-axis
    float polar = acos(cartesian.z / radius);

    return vec3(radius, azimuth, polar); // Return coordinates in the radial system
}