using Toybox.WatchUi;
using Toybox.Graphics;
using Toybox.System;
using Toybox.Lang;
using Toybox.Time.Gregorian;
using Toybox.Timer;
using Toybox.Math;
using Toybox.Attention;

class View extends WatchUi.View
{
	var rbbslogo;
	var badMs = 0;
	const campos_y = -100.0;
	var tmpquat = [0.0, 0.0, 0.0, 0.0];
/*jeanine:p:i:1;p:0;a:b;y:3.00;*/
var a = Math.toRadians(10);
var w = 5.0;
// order: point closest to camera, then furthest. see revision-breakdown.pdn
var revisionLogoPointsOuterIMMUTABLE = [
	/*
	Math.cos(a * 0) * 90.0, Math.sin(a * 0) * 90.0, w, // 0
	Math.cos(a * 0) * 90.0, Math.sin(a * 0) * 90.0, -w,
	Math.cos(a * 0) * 80.0, Math.sin(a * 0) * 80.0, w,
	Math.cos(a * 0) * 80.0, Math.sin(a * 0) * 80.0, -w,
	Math.cos(a * 0) * 70.0, Math.sin(a * 0) * 70.0, w,
	Math.cos(a * 0) * 70.0, Math.sin(a * 0) * 70.0, -w,
	Math.cos(a * 2) * 70.0, Math.sin(a * 2) * 70.0, w,
	Math.cos(a * 2) * 70.0, Math.sin(a * 2) * 70.0, -w,
	Math.cos(a * 2) * 80.0, Math.sin(a * 2) * 80.0, w,
	Math.cos(a * 2) * 80.0, Math.sin(a * 2) * 80.0, -w,
	Math.cos(a * 2) * 90.0, Math.sin(a * 2) * 90.0, w,
	Math.cos(a * 2) * 90.0, Math.sin(a * 2) * 90.0, -w,
	Math.cos(a * 3) * 90.0, Math.sin(a * 3) * 90.0, w,
	Math.cos(a * 3) * 90.0, Math.sin(a * 3) * 90.0, -w,
	Math.cos(a * 3) * 80.0, Math.sin(a * 3) * 80.0, w,
	Math.cos(a * 3) * 80.0, Math.sin(a * 3) * 80.0, -w,
	Math.cos(a * 3) * 70.0, Math.sin(a * 3) * 70.0, w,
	Math.cos(a * 3) * 70.0, Math.sin(a * 3) * 70.0, -w,
	Math.cos(a * 4) * 70.0, Math.sin(a * 4) * 70.0, w,
	Math.cos(a * 4) * 70.0, Math.sin(a * 4) * 70.0, -w,
	Math.cos(a * 4) * 80.0, Math.sin(a * 4) * 80.0, w, // 20
	Math.cos(a * 4) * 80.0, Math.sin(a * 4) * 80.0, -w,
	Math.cos(a * 4) * 90.0, Math.sin(a * 4) * 90.0, w,
	Math.cos(a * 4) * 90.0, Math.sin(a * 4) * 90.0, -w,
	Math.cos(a * 7) * 90.0, Math.sin(a * 7) * 90.0, w,
	Math.cos(a * 7) * 90.0, Math.sin(a * 7) * 90.0, -w,
	Math.cos(a * 7) * 80.0, Math.sin(a * 7) * 80.0, w,
	Math.cos(a * 7) * 80.0, Math.sin(a * 7) * 80.0, -w,
	Math.cos(a * 7) * 70.0, Math.sin(a * 7) * 70.0, w,
	Math.cos(a * 7) * 70.0, Math.sin(a * 7) * 70.0, -w,
	Math.cos(a * 10) * 70.0, Math.sin(a * 10) * 70.0, w,
	Math.cos(a * 10) * 70.0, Math.sin(a * 10) * 70.0, -w,
	Math.cos(a * 10) * 80.0, Math.sin(a * 10) * 80.0, w,
	Math.cos(a * 10) * 80.0, Math.sin(a * 10) * 80.0, -w,
	Math.cos(a * 10) * 90.0, Math.sin(a * 10) * 90.0, w,
	Math.cos(a * 10) * 90.0, Math.sin(a * 10) * 90.0, -w,
	Math.cos(a * 13) * 90.0, Math.sin(a * 13) * 90.0, w,
	Math.cos(a * 13) * 90.0, Math.sin(a * 13) * 90.0, -w,
	Math.cos(a * 13) * 80.0, Math.sin(a * 13) * 80.0, w,
	Math.cos(a * 13) * 80.0, Math.sin(a * 13) * 80.0, -w,
	Math.cos(a * 13) * 70.0, Math.sin(a * 13) * 70.0, w, // 40
	Math.cos(a * 13) * 70.0, Math.sin(a * 13) * 70.0, -w,
	Math.cos(a * 13) * 98.0, Math.sin(a * 13) * 98.0, w,
	Math.cos(a * 13) * 98.0, Math.sin(a * 13) * 98.0, -w,
	Math.cos(a * 14) * 98.0, Math.sin(a * 14) * 98.0, w,
	Math.cos(a * 14) * 98.0, Math.sin(a * 14) * 98.0, -w,
	Math.cos(a * 14) * 90.0, Math.sin(a * 14) * 90.0, w,
	Math.cos(a * 14) * 90.0, Math.sin(a * 14) * 90.0, -w,
	Math.cos(a * 14) * 70.0, Math.sin(a * 14) * 70.0, w,
	Math.cos(a * 14) * 70.0, Math.sin(a * 14) * 70.0, -w,
	Math.cos(a * 17) * 70.0, Math.sin(a * 17) * 70.0, w,
	Math.cos(a * 17) * 70.0, Math.sin(a * 17) * 70.0, -w,
	Math.cos(a * 17) * 90.0, Math.sin(a * 17) * 90.0, w,
	Math.cos(a * 17) * 90.0, Math.sin(a * 17) * 90.0, -w,
	Math.cos(a * 19) * 90.0, Math.sin(a * 19) * 90.0, w,
	Math.cos(a * 19) * 90.0, Math.sin(a * 19) * 90.0, -w,
	Math.cos(a * 19) * 80.0, Math.sin(a * 19) * 80.0, w,
	Math.cos(a * 19) * 80.0, Math.sin(a * 19) * 80.0, -w,
	Math.cos(a * 19) * 70.0, Math.sin(a * 19) * 70.0, w,
	Math.cos(a * 19) * 70.0, Math.sin(a * 19) * 70.0, -w,
	Math.cos(a * 22) * 80.0, Math.sin(a * 22) * 80.0, w, // 60
	Math.cos(a * 22) * 80.0, Math.sin(a * 22) * 80.0, -w,
	Math.cos(a * 22) * 90.0, Math.sin(a * 22) * 90.0, w,
	Math.cos(a * 22) * 90.0, Math.sin(a * 22) * 90.0, -w,
	Math.cos(a * 25) * 90.0, Math.sin(a * 25) * 90.0, w,
	Math.cos(a * 25) * 90.0, Math.sin(a * 25) * 90.0, -w,
	Math.cos(a * 25) * 80.0, Math.sin(a * 25) * 80.0, w,
	Math.cos(a * 25) * 80.0, Math.sin(a * 25) * 80.0, -w,
	Math.cos(a * 25) * 70.0, Math.sin(a * 25) * 70.0, w,
	Math.cos(a * 25) * 70.0, Math.sin(a * 25) * 70.0, -w,
	Math.cos(a * 27) * 70.0, Math.sin(a * 27) * 70.0, w,
	Math.cos(a * 27) * 70.0, Math.sin(a * 27) * 70.0, -w,
	Math.cos(a * 27) * 80.0, Math.sin(a * 27) * 80.0, w,
	Math.cos(a * 27) * 80.0, Math.sin(a * 27) * 80.0, -w,
	Math.cos(a * 27) * 90.0, Math.sin(a * 27) * 90.0, w,
	Math.cos(a * 27) * 90.0, Math.sin(a * 27) * 90.0, -w,
	Math.cos(a * 29) * 90.0, Math.sin(a * 29) * 90.0, w,
	Math.cos(a * 29) * 90.0, Math.sin(a * 29) * 90.0, -w,
	Math.cos(a * 29) * 80.0, Math.sin(a * 29) * 80.0, w,
	Math.cos(a * 29) * 80.0, Math.sin(a * 29) * 80.0, -w,
	Math.cos(a * 29) * 70.0, Math.sin(a * 29) * 70.0, w, // 80
	Math.cos(a * 29) * 70.0, Math.sin(a * 29) * 70.0, -w,
	Math.cos(a * 30) * 70.0, Math.sin(a * 30) * 70.0, w,
	Math.cos(a * 30) * 70.0, Math.sin(a * 30) * 70.0, -w,
	Math.cos(a * 30) * 80.0, Math.sin(a * 30) * 80.0, w,
	Math.cos(a * 30) * 80.0, Math.sin(a * 30) * 80.0, -w,
	Math.cos(a * 30) * 90.0, Math.sin(a * 30) * 90.0, w,
	Math.cos(a * 30) * 90.0, Math.sin(a * 30) * 90.0, -w,
	Math.cos(a * 30) * 98.0, Math.sin(a * 30) * 98.0, w,
	Math.cos(a * 30) * 98.0, Math.sin(a * 30) * 98.0, -w,
	Math.cos(a * 33) * 98.0, Math.sin(a * 33) * 98.0, w,
	Math.cos(a * 33) * 98.0, Math.sin(a * 33) * 98.0, -w,
	Math.cos(a * 33) * 80.0, Math.sin(a * 33) * 80.0, w,
	Math.cos(a * 33) * 80.0, Math.sin(a * 33) * 80.0, -w,
	Math.cos(a * 36) * 98.0, Math.sin(a * 36) * 98.0, w, // 94
	Math.cos(a * 36) * 98.0, Math.sin(a * 36) * 98.0, -w,
	*/
	90,0,5,
	90,0,-5,
	80,0,5,
	80,0,-5,
	70,0,5,
	70,0,-5,
	65.778483,23.941410,5,
	65.778483,23.941410,-5,
	75.175410,27.361611,5,
	75.175410,27.361611,-5,
	84.572336,30.781813,5,
	84.572336,30.781813,-5,
	77.942286,45,5,
	77.942286,45,-5,
	69.282032,40,5,
	69.282032,40,-5,
	60.621778,35,5,
	60.621778,35,-5,
	53.623111,44.995133,5,
	53.623111,44.995133,-5,
	61.283555,51.423009,5,
	61.283555,51.423009,-5,
	68.944000,57.850885,5,
	68.944000,57.850885,-5,
	30.781813,84.572336,5,
	30.781813,84.572336,-5,
	27.361611,75.175410,5,
	27.361611,75.175410,-5,
	23.941410,65.778483,5,
	23.941410,65.778483,-5,
	-12.155372,68.936543,5,
	-12.155372,68.936543,-5,
	-13.891854,78.784620,5,
	-13.891854,78.784620,-5,
	-15.628336,88.632698,5,
	-15.628336,88.632698,-5,
	-57.850885,68.944000,5,
	-57.850885,68.944000,-5,
	-51.423009,61.283555,5,
	-51.423009,61.283555,-5,
	-44.995133,53.623111,5,
	-44.995133,53.623111,-5,
	-62.993186,75.072355,5,
	-62.993186,75.072355,-5,
	-75.072355,62.993186,5,
	-75.072355,62.993186,-5,
	-68.944000,57.850885,5,
	-68.944000,57.850885,-5,
	-53.623111,44.995133,5,
	-53.623111,44.995133,-5,
	-68.936543,12.155372,5,
	-68.936543,12.155372,-5,
	-88.632698,15.628336,5,
	-88.632698,15.628336,-5,
	-88.632698,-15.628336,5,
	-88.632698,-15.628336,-5,
	-78.784620,-13.891854,5,
	-78.784620,-13.891854,-5,
	-68.936543,-12.155372,5,
	-68.936543,-12.155372,-5,
	-61.283555,-51.423009,5,
	-61.283555,-51.423009,-5,
	-68.944000,-57.850885,5,
	-68.944000,-57.850885,-5,
	-30.781813,-84.572336,5,
	-30.781813,-84.572336,-5,
	-27.361611,-75.175410,5,
	-27.361611,-75.175410,-5,
	-23.941410,-65.778483,5,
	-23.941410,-65.778483,-5,
	0,-70,5,
	0,-70,-5,
	0,-80,5,
	0,-80,-5,
	0,-90,5,
	0,-90,-5,
	30.781813,-84.572336,5,
	30.781813,-84.572336,-5,
	27.361611,-75.175410,5,
	27.361611,-75.175410,-5,
	23.941410,-65.778483,5,
	23.941410,-65.778483,-5,
	35,-60.621778,5,
	35,-60.621778,-5,
	40,-69.282032,5,
	40,-69.282032,-5,
	45,-77.942286,5,
	45,-77.942286,-5,
	49,-84.870490,5,
	49,-84.870490,-5,
	84.870490,-49,5,
	84.870490,-49,-5,
	69.282032,-40,5,
	69.282032,-40,-5,
	98,0,5,
	98,0,-5,
];
var revisionLogoPointsOuter = new [96*3];

var revisionLogoPointsMiddleIMMUTABLE = [
	/*
	Math.cos(a * 1) * 40.0, Math.sin(a * 1) * 40.0, w, // 0
	Math.cos(a * 1) * 40.0, Math.sin(a * 1) * 40.0, -w,
	Math.cos(a * 1) * 56.0, Math.sin(a * 1) * 56.0, w,
	Math.cos(a * 1) * 56.0, Math.sin(a * 1) * 56.0, -w,
	Math.cos(a * 3) * 56.0, Math.sin(a * 3) * 56.0, w,
	Math.cos(a * 3) * 56.0, Math.sin(a * 3) * 56.0, -w,
	Math.cos(a * 3) * 40.0, Math.sin(a * 3) * 40.0, w,
	Math.cos(a * 3) * 40.0, Math.sin(a * 3) * 40.0, -w,
	Math.cos(a * 3) * 30.0, Math.sin(a * 3) * 30.0, w,
	Math.cos(a * 3) * 30.0, Math.sin(a * 3) * 30.0, -w,
	Math.cos(a * 5) * 30.0, Math.sin(a * 5) * 30.0, w,
	Math.cos(a * 5) * 30.0, Math.sin(a * 5) * 30.0, -w,
	Math.cos(a * 5) * 56.0, Math.sin(a * 5) * 56.0, w,
	Math.cos(a * 5) * 56.0, Math.sin(a * 5) * 56.0, -w,
	Math.cos(a * 7) * 56.0, Math.sin(a * 7) * 56.0, w,
	Math.cos(a * 7) * 56.0, Math.sin(a * 7) * 56.0, -w,
	Math.cos(a * 7) * 40.0, Math.sin(a * 7) * 40.0, w,
	Math.cos(a * 7) * 40.0, Math.sin(a * 7) * 40.0, -w,
	Math.cos(a * 9) * 40.0, Math.sin(a * 9) * 40.0, w,
	Math.cos(a * 9) * 40.0, Math.sin(a * 9) * 40.0, -w,
	Math.cos(a * 9) * 50.0, Math.sin(a * 9) * 50.0, w, // 20
	Math.cos(a * 9) * 50.0, Math.sin(a * 9) * 50.0, -w,
	Math.cos(a * 9) * 56.0, Math.sin(a * 9) * 56.0, w,
	Math.cos(a * 9) * 56.0, Math.sin(a * 9) * 56.0, -w,
	Math.cos(a * 11) * 56.0, Math.sin(a * 11) * 56.0, w,
	Math.cos(a * 11) * 56.0, Math.sin(a * 11) * 56.0, -w,
	Math.cos(a * 11) * 50.0, Math.sin(a * 11) * 50.0, w,
	Math.cos(a * 11) * 50.0, Math.sin(a * 11) * 50.0, -w,
	Math.cos(a * 13) * 50.0, Math.sin(a * 13) * 50.0, w,
	Math.cos(a * 13) * 50.0, Math.sin(a * 13) * 50.0, -w,
	Math.cos(a * 13) * 56.0, Math.sin(a * 13) * 56.0, w,
	Math.cos(a * 13) * 56.0, Math.sin(a * 13) * 56.0, -w,
	Math.cos(a * 15) * 56.0, Math.sin(a * 15) * 56.0, w,
	Math.cos(a * 15) * 56.0, Math.sin(a * 15) * 56.0, -w,
	Math.cos(a * 15) * 50.0, Math.sin(a * 15) * 50.0, w,
	Math.cos(a * 15) * 50.0, Math.sin(a * 15) * 50.0, -w,
	Math.cos(a * 17) * 50.0, Math.sin(a * 17) * 50.0, w,
	Math.cos(a * 17) * 50.0, Math.sin(a * 17) * 50.0, -w,
	Math.cos(a * 17) * 56.0, Math.sin(a * 17) * 56.0, w,
	Math.cos(a * 17) * 56.0, Math.sin(a * 17) * 56.0, -w,
	Math.cos(a * 19) * 56.0, Math.sin(a * 19) * 56.0, w, // 40
	Math.cos(a * 19) * 56.0, Math.sin(a * 19) * 56.0, -w,
	Math.cos(a * 19) * 40.0, Math.sin(a * 19) * 40.0, w,
	Math.cos(a * 19) * 40.0, Math.sin(a * 19) * 40.0, -w,
	Math.cos(a * 17) * 40.0, Math.sin(a * 17) * 40.0, w,
	Math.cos(a * 17) * 40.0, Math.sin(a * 17) * 40.0, -w,
	Math.cos(a * 19) * 30.0, Math.sin(a * 19) * 30.0, w,
	Math.cos(a * 19) * 30.0, Math.sin(a * 19) * 30.0, -w,
	Math.cos(a * 21) * 30.0, Math.sin(a * 21) * 30.0, w,
	Math.cos(a * 21) * 30.0, Math.sin(a * 21) * 30.0, -w,
	Math.cos(a * 21) * 40.0, Math.sin(a * 21) * 40.0, w,
	Math.cos(a * 21) * 40.0, Math.sin(a * 21) * 40.0, -w,
	Math.cos(a * 21) * 56.0, Math.sin(a * 21) * 56.0, w,
	Math.cos(a * 21) * 56.0, Math.sin(a * 21) * 56.0, -w,
	Math.cos(a * 23) * 56.0, Math.sin(a * 23) * 56.0, w,
	Math.cos(a * 23) * 56.0, Math.sin(a * 23) * 56.0, -w,
	Math.cos(a * 23) * 50.0, Math.sin(a * 23) * 50.0, w,
	Math.cos(a * 23) * 50.0, Math.sin(a * 23) * 50.0, -w,
	Math.cos(a * 23) * 40.0, Math.sin(a * 23) * 40.0, w,
	Math.cos(a * 23) * 40.0, Math.sin(a * 23) * 40.0, -w,
	Math.cos(a * 25) * 40.0, Math.sin(a * 25) * 40.0, w, // 60
	Math.cos(a * 25) * 40.0, Math.sin(a * 25) * 40.0, -w,
	Math.cos(a * 25) * 50.0, Math.sin(a * 25) * 50.0, w,
	Math.cos(a * 25) * 50.0, Math.sin(a * 25) * 50.0, -w,
	Math.cos(a * 25) * 56.0, Math.sin(a * 25) * 56.0, w,
	Math.cos(a * 25) * 56.0, Math.sin(a * 25) * 56.0, -w,
	Math.cos(a * 27) * 56.0, Math.sin(a * 27) * 56.0, w,
	Math.cos(a * 27) * 56.0, Math.sin(a * 27) * 56.0, -w,
	Math.cos(a * 27) * 40.0, Math.sin(a * 27) * 40.0, w,
	Math.cos(a * 27) * 40.0, Math.sin(a * 27) * 40.0, -w,
	Math.cos(a * 27) * 30.0, Math.sin(a * 27) * 30.0, w,
	Math.cos(a * 27) * 30.0, Math.sin(a * 27) * 30.0, -w,
	Math.cos(a * 29) * 30.0, Math.sin(a * 29) * 30.0, w,
	Math.cos(a * 29) * 30.0, Math.sin(a * 29) * 30.0, -w,
	Math.cos(a * 29) * 56.0, Math.sin(a * 29) * 56.0, w,
	Math.cos(a * 29) * 56.0, Math.sin(a * 29) * 56.0, -w,
	Math.cos(a * 31) * 56.0, Math.sin(a * 31) * 56.0, w,
	Math.cos(a * 31) * 56.0, Math.sin(a * 31) * 56.0, -w,
	Math.cos(a * 31) * 40.0, Math.sin(a * 31) * 40.0, w,
	Math.cos(a * 31) * 40.0, Math.sin(a * 31) * 40.0, -w,
	Math.cos(a * 31) * 30.0, Math.sin(a * 31) * 30.0, w, // 80
	Math.cos(a * 31) * 30.0, Math.sin(a * 31) * 30.0, -w,
	Math.cos(a * 33) * 40.0, Math.sin(a * 33) * 40.0, w,
	Math.cos(a * 33) * 40.0, Math.sin(a * 33) * 40.0, -w,
	Math.cos(a * 33) * 50.0, Math.sin(a * 33) * 50.0, w,
	Math.cos(a * 33) * 50.0, Math.sin(a * 33) * 50.0, -w,
	Math.cos(a * 33) * 56.0, Math.sin(a * 33) * 56.0, w,
	Math.cos(a * 33) * 56.0, Math.sin(a * 33) * 56.0, -w,
	Math.cos(a * 35) * 56.0, Math.sin(a * 35) * 56.0, w,
	Math.cos(a * 35) * 56.0, Math.sin(a * 35) * 56.0, -w,
	Math.cos(a * 35) * 50.0, Math.sin(a * 35) * 50.0, w,
	Math.cos(a * 35) * 50.0, Math.sin(a * 35) * 50.0, -w,
	Math.cos(a * 35) * 40.0, Math.sin(a * 35) * 40.0, w, // 92
	Math.cos(a * 35) * 40.0, Math.sin(a * 35) * 40.0, -w,
	Math.cos(a * 7) * 30.0, Math.sin(a * 7) * 30.0, w, // 94
	Math.cos(a * 7) * 30.0, Math.sin(a * 7) * 30.0, -w,
	*/
	39.392310,6.945927,5,
	39.392310,6.945927,-5,
	55.149234,9.724298,5,
	55.149234,9.724298,-5,
	48.497423,28,5,
	48.497423,28,-5,
	34.641016,20,5,
	34.641016,20,-5,
	25.980762,15,5,
	25.980762,15,-5,
	19.283628,22.981333,5,
	19.283628,22.981333,-5,
	35.996106,42.898489,5,
	35.996106,42.898489,-5,
	19.153128,52.622787,5,
	19.153128,52.622787,-5,
	13.680806,37.587705,5,
	13.680806,37.587705,-5,
	0,40,5,
	0,40,-5,
	0,50,5,
	0,50,-5,
	0,56,5,
	0,56,-5,
	-19.153128,52.622787,5,
	-19.153128,52.622787,-5,
	-17.101007,46.984631,5,
	-17.101007,46.984631,-5,
	-32.139380,38.302222,5,
	-32.139380,38.302222,-5,
	-35.996106,42.898489,5,
	-35.996106,42.898489,-5,
	-48.497423,28,5,
	-48.497423,28,-5,
	-43.301270,25,5,
	-43.301270,25,-5,
	-49.240388,8.682409,5,
	-49.240388,8.682409,-5,
	-55.149234,9.724298,5,
	-55.149234,9.724298,-5,
	-55.149234,-9.724298,5,
	-55.149234,-9.724298,-5,
	-39.392310,-6.945927,5,
	-39.392310,-6.945927,-5,
	-39.392310,6.945927,5,
	-39.392310,6.945927,-5,
	-29.544233,-5.209445,5,
	-29.544233,-5.209445,-5,
	-25.980762,-15,5,
	-25.980762,-15,-5,
	-34.641016,-20,5,
	-34.641016,-20,-5,
	-48.497423,-28,5,
	-48.497423,-28,-5,
	-35.996106,-42.898489,5,
	-35.996106,-42.898489,-5,
	-32.139380,-38.302222,5,
	-32.139380,-38.302222,-5,
	-25.711504,-30.641778,5,
	-25.711504,-30.641778,-5,
	-13.680806,-37.587705,5,
	-13.680806,-37.587705,-5,
	-17.101007,-46.984631,5,
	-17.101007,-46.984631,-5,
	-19.153128,-52.622787,5,
	-19.153128,-52.622787,-5,
	0,-56,5,
	0,-56,-5,
	0,-40,5,
	0,-40,-5,
	0,-30,5,
	0,-30,-5,
	10.260604,-28.190779,5,
	10.260604,-28.190779,-5,
	19.153128,-52.622787,5,
	19.153128,-52.622787,-5,
	35.996106,-42.898489,5,
	35.996106,-42.898489,-5,
	25.711504,-30.641778,5,
	25.711504,-30.641778,-5,
	19.283628,-22.981333,5,
	19.283628,-22.981333,-5,
	34.641016,-20,5,
	34.641016,-20,-5,
	43.301270,-25,5,
	43.301270,-25,-5,
	48.497423,-28,5,
	48.497423,-28,-5,
	55.149234,-9.724298,5,
	55.149234,-9.724298,-5,
	49.240388,-8.682409,5,
	49.240388,-8.682409,-5,
	39.392310,-6.945927,5,
	39.392310,-6.945927,-5,
	10.260604,28.190779,5,
	10.260604,28.190779,-5,
];
var revisionLogoPointsMiddle = new[96*3];

var revisionLogoPointsInnerIMMUTABLE = [
	/*
	Math.cos(a * 1) * 16.0, Math.sin(a * 1) * 16.0, w, // 0
	Math.cos(a * 1) * 16.0, Math.sin(a * 1) * 16.0, -w,
	Math.cos(a * 1) * 7.0, Math.sin(a * 1) * 7.0, w,
	Math.cos(a * 1) * 7.0, Math.sin(a * 1) * 7.0, -w,
	Math.cos(a * 4) * 7.0, Math.sin(a * 4) * 7.0, w,
	Math.cos(a * 4) * 7.0, Math.sin(a * 4) * 7.0, -w,
	Math.cos(a * 4) * 16.0, Math.sin(a * 4) * 16.0, w,
	Math.cos(a * 4) * 16.0, Math.sin(a * 4) * 16.0, -w,
	Math.cos(a * 7) * 16.0, Math.sin(a * 7) * 16.0, w,
	Math.cos(a * 7) * 16.0, Math.sin(a * 7) * 16.0, -w,
	Math.cos(a * 7) * 7.0, Math.sin(a * 7) * 7.0, w,
	Math.cos(a * 7) * 7.0, Math.sin(a * 7) * 7.0, -w,
	Math.cos(a * 10) * 7.0, Math.sin(a * 10) * 7.0, w,
	Math.cos(a * 10) * 7.0, Math.sin(a * 10) * 7.0, -w,
	Math.cos(a * 10) * 16.0, Math.sin(a * 10) * 16.0, w,
	Math.cos(a * 10) * 16.0, Math.sin(a * 10) * 16.0, -w,
	Math.cos(a * 10) * 28.0, Math.sin(a * 10) * 28.0, w,
	Math.cos(a * 10) * 28.0, Math.sin(a * 10) * 28.0, -w,
	Math.cos(a * 13) * 28.0, Math.sin(a * 13) * 28.0, w,
	Math.cos(a * 13) * 28.0, Math.sin(a * 13) * 28.0, -w,
	Math.cos(a * 13) * 7.0, Math.sin(a * 13) * 7.0, w, // 20
	Math.cos(a * 13) * 7.0, Math.sin(a * 13) * 7.0, -w,
	Math.cos(a * 16) * 28.0, Math.sin(a * 16) * 28.0, w,
	Math.cos(a * 16) * 28.0, Math.sin(a * 16) * 28.0, -w,
	Math.cos(a * 16) * 16.0, Math.sin(a * 16) * 16.0, w,
	Math.cos(a * 16) * 16.0, Math.sin(a * 16) * 16.0, -w,
	Math.cos(a * 16) * 7.0, Math.sin(a * 16) * 7.0, w,
	Math.cos(a * 16) * 7.0, Math.sin(a * 16) * 7.0, -w,
	Math.cos(a * 19) * 7.0, Math.sin(a * 19) * 7.0, w,
	Math.cos(a * 19) * 7.0, Math.sin(a * 19) * 7.0, -w,
	Math.cos(a * 19) * 16.0, Math.sin(a * 19) * 16.0, w,
	Math.cos(a * 19) * 16.0, Math.sin(a * 19) * 16.0, -w,
	Math.cos(a * 22) * 16.0, Math.sin(a * 22) * 16.0, w,
	Math.cos(a * 22) * 16.0, Math.sin(a * 22) * 16.0, -w,
	Math.cos(a * 22) * 7.0, Math.sin(a * 22) * 7.0, w,
	Math.cos(a * 22) * 7.0, Math.sin(a * 22) * 7.0, -w,
	Math.cos(a * 25) * 7.0, Math.sin(a * 25) * 7.0, w,
	Math.cos(a * 25) * 7.0, Math.sin(a * 25) * 7.0, -w,
	Math.cos(a * 25) * 16.0, Math.sin(a * 25) * 16.0, w,
	Math.cos(a * 25) * 16.0, Math.sin(a * 25) * 16.0, -w,
	Math.cos(a * 28) * 16.0, Math.sin(a * 28) * 16.0, w, // 40
	Math.cos(a * 28) * 16.0, Math.sin(a * 28) * 16.0, -w,
	Math.cos(a * 28) * 7.0, Math.sin(a * 28) * 7.0, w,
	Math.cos(a * 28) * 7.0, Math.sin(a * 28) * 7.0, -w,
	Math.cos(a * 31) * 7.0, Math.sin(a * 31) * 7.0, w,
	Math.cos(a * 31) * 7.0, Math.sin(a * 31) * 7.0, -w,
	Math.cos(a * 31) * 16.0, Math.sin(a * 31) * 16.0, w,
	Math.cos(a * 31) * 16.0, Math.sin(a * 31) * 16.0, -w,
	Math.cos(a * 34) * 16.0, Math.sin(a * 34) * 16.0, w,
	Math.cos(a * 34) * 16.0, Math.sin(a * 34) * 16.0, -w,
	Math.cos(a * 34) * 7.0, Math.sin(a * 34) * 7.0, w, // 50
	Math.cos(a * 34) * 7.0, Math.sin(a * 34) * 7.0, -w,
	*/
	15.756924,2.778371,5,
	15.756924,2.778371,-5,
	6.893654,1.215537,5,
	6.893654,1.215537,-5,
	5.362311,4.499513,5,
	5.362311,4.499513,-5,
	12.256711,10.284602,5,
	12.256711,10.284602,-5,
	5.472322,15.035082,5,
	5.472322,15.035082,-5,
	2.394141,6.577848,5,
	2.394141,6.577848,-5,
	-1.215537,6.893654,5,
	-1.215537,6.893654,-5,
	-2.778371,15.756924,5,
	-2.778371,15.756924,-5,
	-4.862149,27.574617,5,
	-4.862149,27.574617,-5,
	-17.998053,21.449244,5,
	-17.998053,21.449244,-5,
	-4.499513,5.362311,5,
	-4.499513,5.362311,-5,
	-26.311393,9.576564,5,
	-26.311393,9.576564,-5,
	-15.035082,5.472322,5,
	-15.035082,5.472322,-5,
	-6.577848,2.394141,5,
	-6.577848,2.394141,-5,
	-6.893654,-1.215537,5,
	-6.893654,-1.215537,-5,
	-15.756924,-2.778371,5,
	-15.756924,-2.778371,-5,
	-12.256711,-10.284602,5,
	-12.256711,-10.284602,-5,
	-5.362311,-4.499513,5,
	-5.362311,-4.499513,-5,
	-2.394141,-6.577848,5,
	-2.394141,-6.577848,-5,
	-5.472322,-15.035082,5,
	-5.472322,-15.035082,-5,
	2.778371,-15.756924,5,
	2.778371,-15.756924,-5,
	1.215537,-6.893654,5,
	1.215537,-6.893654,-5,
	4.499513,-5.362311,5,
	4.499513,-5.362311,-5,
	10.284602,-12.256711,5,
	10.284602,-12.256711,-5,
	15.035082,-5.472322,5,
	15.035082,-5.472322,-5,
	6.577848,-2.394141,5,
	6.577848,-2.394141,-5,
];
var revisionLogoPointsInner = new [52*3];
/*jeanine:p:i:3;p:1;a:t;x:3.75;*/
var revisionLogoFacesOuterFront = [
	0, 10, 6, 4,
	8, 10, 12, 14,
	16, 12, 22, 18,
	20, 22, 24, 26,
	28, 24, 34, 30,
	32, 34, 36, 38,
	40, 42, 44, 48,
	48, 46, 52, 50,
	50, 52, 54, 58,
	56, 54, 62, 60,
	60, 62, 64, 66,
	68, 64, 74, 70,
	72, 74, 76, 78,
	80, 76, 86, 82,
	84, 88, 90, 92,
	92, 90, 94, 2,
];
var revisionLogoFacesOuterBack = new [16*4];
var revisionLogoFacesOuterLR = [
	10, 0, 1, 11, 4, 6, 7, 5,
	12, 10, 11, 13, 8, 14, 15, 9,
	22, 12, 13, 23, 16, 18, 19, 17,
	24, 22, 23, 25, 20, 26, 27, 21,
	34, 24, 25, 35, 28, 30, 31, 29,
	36, 34, 35, 37, 32, 38, 39, 33,
	44, 42, 43, 45, 40, 48, 49, 41,
	52, 46, 47, 53, 48, 50, 51, 49,
	54, 52, 53, 55, 50, 58, 59, 51,
	62, 54, 55, 63, 56, 60, 61, 57,
	64, 62, 63, 65, 60, 66, 67, 61,
	74, 64, 65, 75, 68, 70, 71, 69,
	76, 74, 75, 77, 72, 78, 79, 73,
	86, 76, 77, 87, 80, 82, 83, 81,
	90, 88, 89, 91, 84, 92, 93, 85,
	94, 90, 91, 95, 92, 2, 3, 93,
];
var revisionLogoFacesOuterUD = [
	0, 94, 95, 1,
	2, 4, 5, 3,
	6, 8, 9, 7,
	14, 16, 17, 15,
	18, 20, 21, 19,
	26, 28, 29, 27,
	30, 32, 33, 31,
	38, 40, 41, 39,
	42, 36, 37, 43,
	46, 44, 45, 47,
	58, 56, 57, 59,
	66, 68, 69, 67,
	70, 72, 73, 71,
	78, 80, 81, 79,
	82, 84, 85, 83,
	88, 86, 87, 89,
];

var revisionLogoFacesMiddleFront = [
	0, 2, 4, 6,
	8, 4, 12, 10,
	10, 12, 14, 94,
	16, 14, 22, 18,
	20, 22, 24, 26,
	26, 24, 30, 28,
	28, 30, 32, 34,
	34, 32, 38, 36,
	44, 38, 40, 42,
	46, 40, 52, 48,
	50, 52, 54, 58,
	56, 54, 64, 62,
	60, 64, 66, 68,
	70, 66, 74, 72,
	72, 74, 76, 80,
	78, 76, 86, 82,
	84, 86, 88, 90,
	92, 88, 2, 0,
];
var revisionLogoFacesMiddleBack = new [18*4];
var revisionLogoFacesMiddleLR = [
	0, 6, 7, 1, 4, 2, 3, 5,
	8, 10, 11, 9, 12, 4, 5, 13,
	10, 94, 95, 11, 14, 12, 13, 15,
	16, 18, 19, 17, 22, 14, 15, 23,
	20, 26, 27, 21, 24, 22, 23, 25,
	26, 28, 29, 27, 30, 24, 25, 31,
	28, 34, 35, 29, 32, 30, 31, 33,
	34, 36, 37, 35, 38, 32, 33, 39,
	44, 42, 43, 45, 40, 38, 39, 41,
	46, 48, 49, 47, 52, 40, 41, 53,
	50, 58, 59, 51, 54, 52, 53, 55,
	56, 62, 63, 57, 64, 54, 55, 65,
	60, 68, 69, 61, 66, 64, 65, 67,
	70, 72, 73, 71, 74, 66, 67, 75,
	72, 80, 81, 73, 76, 74, 75, 77,
	78, 82, 83, 79, 86, 76, 77, 87,
	84, 90, 91, 85, 88, 86, 87, 89,
	92, 0, 1, 93, 2, 88, 89, 3,
];
var revisionLogoFacesMiddleUD = [
	6, 8, 9, 7,
	94, 16, 17, 95,
	18, 20, 21, 19,
	36, 44, 45, 37,
	42, 46, 47, 43,
	48, 50, 51, 49,
	58, 56, 57, 59,
	62, 60, 61, 63,
	68, 70, 71, 69,
	80, 78, 79, 81,
	82, 84, 85, 83,
	90, 92, 93, 91,
];

var revisionLogoFacesInnerFront = [
	2, 0, 6, 4,
	4, 6, 8, 10,
	10, 8, 14, 12,
	12, 16, 18, 20,
	20, 18, 22, 26,
	26, 24, 30, 28,
	28, 30, 32, 34,
	34, 32, 38, 36,
	36, 38, 40, 42,
	42, 40, 46, 44,
	44, 46, 48, 50,
	50, 48, 0, 2,
];
var revisionLogoFacesInnerBack = new [12*4];
var revisionLogoFacesInnerLR = [
	6, 0, 1, 7, 2, 4, 5, 3,
	8, 6, 7, 9, 4, 10, 11, 5,
	14, 8, 9, 15, 10, 12, 13, 11,
	18, 16, 17, 19, 12, 20, 21, 13,
	22, 18, 19, 23, 20, 26, 27, 21,
	30, 24, 25, 31, 26, 28, 29, 27,
	32, 30, 31, 33, 28, 34, 35, 29,
	38, 32, 33, 39, 34, 36, 37, 35,
	40, 38, 39, 41, 36, 42, 43, 37,
	46, 40, 41, 47, 42, 44, 45, 43,
	48, 46, 47, 49, 44, 50, 51, 45,
	0, 48, 49, 1, 50, 2, 3, 51,
];
var revisionLogoFacesInnerUD = [
	16, 14, 15, 17,
	24, 22, 23, 25
];
/*jeanine:p:i:4;p:3;a:t;x:3.75;*/
class DrawListEntry
{
	var fill;
	var points;
	var a, b, c, d;
	var distanceToCamera;

	function calcDistanceToCamera()
	{
		//var total;
		var x, y, z;
		x = points[a];
		y = points[a+1] + 100.0; //- campos_y;
		z = points[a+2];
		//total = Math.sqrt(x * x + y * y + z * z);
		self.distanceToCamera = x*x+y*y+z*z;
		x = points[b];
		y = points[b+1] + 100.0; //- campos_y;
		z = points[b+2];
		//total += Math.sqrt(x * x + y * y + z * z);
		self.distanceToCamera += x*x+y*y+z*z;
		x = points[c];
		y = points[c+1] + 100.0; //- campos_y;
		z = points[c+2];
		//total += Math.sqrt(x * x + y * y + z * z);
		self.distanceToCamera += x*x+y*y+z*z;
		x = points[d];
		y = points[d+1] + 100.0; //- campos_y;
		z = points[d+2];
		//total += Math.sqrt(x * x + y * y + z * z);
		self.distanceToCamera += x*x+y*y+z*z;
		//self.distanceToCamera = total / 4.0;
	}
}
var revisionDrawList = new [16+16+16 + 18+18+12 + 12+12+2]; // front/back+left/right + up+down
var revisionDrawListCount;

function initialize_revision_logo()
{
	for (var a = 0; a < 96*3; a+=3) {
		revisionLogoPointsOuterIMMUTABLE[a] *= 0.5;
		revisionLogoPointsOuterIMMUTABLE[a+1] *= 0.5;
	}
	for (var a = 0; a < 96*3; a+=3) {
		revisionLogoPointsMiddleIMMUTABLE[a] *= 0.5;
		revisionLogoPointsMiddleIMMUTABLE[a+1] *= 0.5;
	}
	for (var a = 0; a < 52*3; a+=3) {
		revisionLogoPointsInnerIMMUTABLE[a] *= 0.5;
		revisionLogoPointsInnerIMMUTABLE[a+1] *= 0.5;
	}
	for (var a = 0; a < 16*4; a+=4) {
		revisionLogoFacesOuterBack[a] = revisionLogoFacesOuterFront[a]+1;
		revisionLogoFacesOuterBack[a+1] = revisionLogoFacesOuterFront[a+3]+1;
		revisionLogoFacesOuterBack[a+2] = revisionLogoFacesOuterFront[a+2]+1;
		revisionLogoFacesOuterBack[a+3] = revisionLogoFacesOuterFront[a+1]+1;
	}
	for (var a = 0; a < 18*4; a+=4) {
		revisionLogoFacesMiddleBack[a] = revisionLogoFacesMiddleFront[a]+1;
		revisionLogoFacesMiddleBack[a+1] = revisionLogoFacesMiddleFront[a+3]+1;
		revisionLogoFacesMiddleBack[a+2] = revisionLogoFacesMiddleFront[a+2]+1;
		revisionLogoFacesMiddleBack[a+3] = revisionLogoFacesMiddleFront[a+1]+1;
	}
	for (var a = 0; a < 12*4; a+=4) {
		revisionLogoFacesInnerBack[a] = revisionLogoFacesInnerFront[a]+1;
		revisionLogoFacesInnerBack[a+1] = revisionLogoFacesInnerFront[a+3]+1;
		revisionLogoFacesInnerBack[a+2] = revisionLogoFacesInnerFront[a+2]+1;
		revisionLogoFacesInnerBack[a+3] = revisionLogoFacesInnerFront[a+1]+1;
	}
	for (var a = 0; a < 16+16+16 + 18+18+12 + 12+12+2; a++) {
		revisionDrawList[a] = new DrawListEntry();
	}
}

var revisionLogoFullPhase = 0;
var revisionLogoFullNumDistancesCalculated = 0;
var revisionLogoFullQuats = [[0.0,0.0,0.0,0.0],[0.0,0.0,0.0,0.0],[0.0,0.0,0.0,0.0]];

function revisionlogofull(dc) as Lang.Boolean
{
if (revisionLogoFullPhase == 0) {

	dc.setColor(Graphics.COLOR_BLACK, Graphics.COLOR_BLACK);
	dc.fillCircle(dc.getWidth()/2, dc.getHeight()/2, dc.getWidth()/2-20);

	revisionDrawListCount = 0;
	revisionLogoFullNumDistancesCalculated = 0;
	// outer
	rotate_batch(revisionLogoPointsOuterIMMUTABLE, revisionLogoPointsOuter, 0, 96, revisionLogoFullQuats[0]);
	for (var i = 0; i < 96; i++) {
		revisionLogoPointsOuter[i*3+1] += 25.0;
	}

	revisionLogoFullPhase = 1;
} else if (revisionLogoFullPhase == 1) {

	// outer front/back
	var dot_front = face_normal_dot_rayvec(revisionLogoPointsOuter, revisionLogoFacesOuterFront, 0);
	if (dot_front > 0) {
		for (var a = 0; a < 16 * 4; a+=4) {
			var drawListEntry = revisionDrawList[revisionDrawListCount];
			revisionDrawListCount++;
			drawListEntry.fill = Graphics.COLOR_WHITE;
			drawListEntry.points = revisionLogoPointsOuter;
			drawListEntry.a = revisionLogoFacesOuterFront[a]*3;
			drawListEntry.b = revisionLogoFacesOuterFront[a+1]*3;
			drawListEntry.c = revisionLogoFacesOuterFront[a+2]*3;
			drawListEntry.d = revisionLogoFacesOuterFront[a+3]*3;
		}
	} else if (dot_front < 0) {
		for (var a = 0; a < 16 * 4; a+=4) {
			var drawListEntry = revisionDrawList[revisionDrawListCount];
			revisionDrawListCount++;
			drawListEntry.fill = Graphics.COLOR_WHITE;
			drawListEntry.points = revisionLogoPointsOuter;
			drawListEntry.a = revisionLogoFacesOuterBack[a]*3;
			drawListEntry.b = revisionLogoFacesOuterBack[a+1]*3;
			drawListEntry.c = revisionLogoFacesOuterBack[a+2]*3;
			drawListEntry.d = revisionLogoFacesOuterBack[a+3]*3;
		}
	}

	revisionLogoFullPhase = 2;
} else if (revisionLogoFullPhase == 2) {

	// outer left/right
	for (var a = 0; a < 16*8; a+=8) {
		var dot = face_normal_dot_rayvec(revisionLogoPointsOuter, revisionLogoFacesOuterLR, a);
		if (dot != 0) {
			var drawListEntry = revisionDrawList[revisionDrawListCount];
			revisionDrawListCount++;
			drawListEntry.points = revisionLogoPointsOuter;
			if (dot > 0) {
				drawListEntry.fill = Graphics.COLOR_DK_GRAY;
				drawListEntry.a = revisionLogoFacesOuterLR[a]*3;
				drawListEntry.b = revisionLogoFacesOuterLR[a+1]*3;
				drawListEntry.c = revisionLogoFacesOuterLR[a+2]*3;
				drawListEntry.d = revisionLogoFacesOuterLR[a+3]*3;
			} else {
				drawListEntry.fill = Graphics.COLOR_DK_GRAY;
				drawListEntry.a = revisionLogoFacesOuterLR[a+4]*3;
				drawListEntry.b = revisionLogoFacesOuterLR[a+5]*3;
				drawListEntry.c = revisionLogoFacesOuterLR[a+6]*3;
				drawListEntry.d = revisionLogoFacesOuterLR[a+7]*3;
			}
		}
	}

	revisionLogoFullPhase = 3;
} else if (revisionLogoFullPhase == 3) {

	// outer up/down
	for (var a = 0; a < 16*4; a+=4) {
		var dot = face_normal_dot_rayvec(revisionLogoPointsOuter, revisionLogoFacesOuterUD, a);
		if (dot > 0) {
			var drawListEntry = revisionDrawList[revisionDrawListCount];
			revisionDrawListCount++;
			drawListEntry.points = revisionLogoPointsOuter;
			drawListEntry.fill = Graphics.COLOR_DK_GRAY;
			drawListEntry.a = revisionLogoFacesOuterUD[a]*3;
			drawListEntry.b = revisionLogoFacesOuterUD[a+1]*3;
			drawListEntry.c = revisionLogoFacesOuterUD[a+2]*3;
			drawListEntry.d = revisionLogoFacesOuterUD[a+3]*3;
		}
	}

	revisionLogoFullPhase = 4;
} else if (revisionLogoFullPhase == 4) {

	// middle
	rotate_batch(revisionLogoPointsMiddleIMMUTABLE, revisionLogoPointsMiddle, 0, 96, revisionLogoFullQuats[1]);
	for (var i = 0; i < 96; i++) {
		revisionLogoPointsMiddle[i*3+1] += 25.0;
	}

	revisionLogoFullPhase = 5;
} else if (revisionLogoFullPhase == 5) {

	// middle front/back
	var dot_front  = face_normal_dot_rayvec(revisionLogoPointsMiddle, revisionLogoFacesMiddleFront, 0);
	if (dot_front > 0) {
		for (var a = 0; a < 18 * 4; a+=4) {
			var drawListEntry = revisionDrawList[revisionDrawListCount];
			revisionDrawListCount++;
			drawListEntry.fill = Graphics.COLOR_WHITE;
			drawListEntry.points = revisionLogoPointsMiddle;
			drawListEntry.a = revisionLogoFacesMiddleFront[a]*3;
			drawListEntry.b = revisionLogoFacesMiddleFront[a+1]*3;
			drawListEntry.c = revisionLogoFacesMiddleFront[a+2]*3;
			drawListEntry.d = revisionLogoFacesMiddleFront[a+3]*3;
		}
	} else if (dot_front < 0) {
		for (var a = 0; a < 18 * 4; a+=4) {
			var drawListEntry = revisionDrawList[revisionDrawListCount];
			revisionDrawListCount++;
			drawListEntry.fill = Graphics.COLOR_WHITE;
			drawListEntry.points = revisionLogoPointsMiddle;
			drawListEntry.a = revisionLogoFacesMiddleBack[a]*3;
			drawListEntry.b = revisionLogoFacesMiddleBack[a+1]*3;
			drawListEntry.c = revisionLogoFacesMiddleBack[a+2]*3;
			drawListEntry.d = revisionLogoFacesMiddleBack[a+3]*3;
		}
	}

	revisionLogoFullPhase = 6;
} else if (revisionLogoFullPhase == 6) {

	// middle left/right
	for (var a = 0; a < 18*8; a+=8) {
		var dot = face_normal_dot_rayvec(revisionLogoPointsMiddle, revisionLogoFacesMiddleLR, a);
		if (dot != 0) {
			var drawListEntry = revisionDrawList[revisionDrawListCount];
			revisionDrawListCount++;
			drawListEntry.points = revisionLogoPointsMiddle;
			if (dot > 0) {
				drawListEntry.fill = Graphics.COLOR_DK_GRAY;
				drawListEntry.a = revisionLogoFacesMiddleLR[a]*3;
				drawListEntry.b = revisionLogoFacesMiddleLR[a+1]*3;
				drawListEntry.c = revisionLogoFacesMiddleLR[a+2]*3;
				drawListEntry.d = revisionLogoFacesMiddleLR[a+3]*3;
			} else {
				drawListEntry.fill = Graphics.COLOR_DK_GRAY;
				drawListEntry.a = revisionLogoFacesMiddleLR[a+4]*3;
				drawListEntry.b = revisionLogoFacesMiddleLR[a+5]*3;
				drawListEntry.c = revisionLogoFacesMiddleLR[a+6]*3;
				drawListEntry.d = revisionLogoFacesMiddleLR[a+7]*3;
			}
		}
	}

	revisionLogoFullPhase = 7;
} else if (revisionLogoFullPhase == 7) {

	// middle up/down
	for (var a = 0; a < 12*4; a+=4) {
		var dot = face_normal_dot_rayvec(revisionLogoPointsMiddle, revisionLogoFacesMiddleUD, a);
		if (dot > 0) {
			var drawListEntry = revisionDrawList[revisionDrawListCount];
			revisionDrawListCount++;
			drawListEntry.points = revisionLogoPointsMiddle;
			drawListEntry.fill = Graphics.COLOR_DK_GRAY;
			drawListEntry.a = revisionLogoFacesMiddleUD[a]*3;
			drawListEntry.b = revisionLogoFacesMiddleUD[a+1]*3;
			drawListEntry.c = revisionLogoFacesMiddleUD[a+2]*3;
			drawListEntry.d = revisionLogoFacesMiddleUD[a+3]*3;
		}
	}

	revisionLogoFullPhase = 8;
} else if (revisionLogoFullPhase == 8) {

	// inner
	rotate_batch(revisionLogoPointsInnerIMMUTABLE, revisionLogoPointsInner, 0, 52, revisionLogoFullQuats[2]);
	for (var i = 0; i < 52; i++) {
		revisionLogoPointsInner[i*3+1] += 25.0;
	}

	revisionLogoFullPhase = 9;
} else if (revisionLogoFullPhase == 9) {

	// inner front/back
	var dot_front  = face_normal_dot_rayvec(revisionLogoPointsInner, revisionLogoFacesInnerFront, 0);
	if (dot_front > 0) {
		for (var a = 0; a < 12 * 4; a+=4) {
			var drawListEntry = revisionDrawList[revisionDrawListCount];
			revisionDrawListCount++;
			drawListEntry.fill = Graphics.COLOR_WHITE;
			drawListEntry.points = revisionLogoPointsInner;
			drawListEntry.a = revisionLogoFacesInnerFront[a]*3;
			drawListEntry.b = revisionLogoFacesInnerFront[a+1]*3;
			drawListEntry.c = revisionLogoFacesInnerFront[a+2]*3;
			drawListEntry.d = revisionLogoFacesInnerFront[a+3]*3;
		}
	} else if (dot_front < 0) {
		for (var a = 0; a < 12 * 4; a+=4) {
			var drawListEntry = revisionDrawList[revisionDrawListCount];
			revisionDrawListCount++;
			drawListEntry.fill = Graphics.COLOR_WHITE;
			drawListEntry.points = revisionLogoPointsInner;
			drawListEntry.a = revisionLogoFacesInnerBack[a]*3;
			drawListEntry.b = revisionLogoFacesInnerBack[a+1]*3;
			drawListEntry.c = revisionLogoFacesInnerBack[a+2]*3;
			drawListEntry.d = revisionLogoFacesInnerBack[a+3]*3;
		}
	}

	revisionLogoFullPhase = 10;
} else if (revisionLogoFullPhase == 10) {

	// inner left/right
	for (var a = 0; a < 12*8; a+=8) {
		var dot = face_normal_dot_rayvec(revisionLogoPointsInner, revisionLogoFacesInnerLR, a);
		if (dot != 0) {
			var drawListEntry = revisionDrawList[revisionDrawListCount];
			revisionDrawListCount++;
			drawListEntry.points = revisionLogoPointsInner;
			if (dot > 0) {
				drawListEntry.fill = Graphics.COLOR_DK_GRAY;
				drawListEntry.a = revisionLogoFacesInnerLR[a]*3;
				drawListEntry.b = revisionLogoFacesInnerLR[a+1]*3;
				drawListEntry.c = revisionLogoFacesInnerLR[a+2]*3;
				drawListEntry.d = revisionLogoFacesInnerLR[a+3]*3;
			} else {
				drawListEntry.fill = Graphics.COLOR_DK_GRAY;
				drawListEntry.a = revisionLogoFacesInnerLR[a+4]*3;
				drawListEntry.b = revisionLogoFacesInnerLR[a+5]*3;
				drawListEntry.c = revisionLogoFacesInnerLR[a+6]*3;
				drawListEntry.d = revisionLogoFacesInnerLR[a+7]*3;
			}
		}
	}

	revisionLogoFullPhase = 11;
} else if (revisionLogoFullPhase == 11) {

	// inner up/down
	for (var a = 0; a < 2*4; a+=4) {
		var dot = face_normal_dot_rayvec(revisionLogoPointsInner, revisionLogoFacesInnerUD, a);
		if (dot > 0) {
			var drawListEntry = revisionDrawList[revisionDrawListCount];
			revisionDrawListCount++;
			drawListEntry.points = revisionLogoPointsInner;
			drawListEntry.fill = Graphics.COLOR_DK_GRAY;
			drawListEntry.a = revisionLogoFacesInnerUD[a]*3;
			drawListEntry.b = revisionLogoFacesInnerUD[a+1]*3;
			drawListEntry.c = revisionLogoFacesInnerUD[a+2]*3;
			drawListEntry.d = revisionLogoFacesInnerUD[a+3]*3;
		}
	}

	revisionLogoFullPhase = 12;
} else if (revisionLogoFullPhase == 12) {

	// calc distance
	for (var thisFrame = 0; revisionLogoFullNumDistancesCalculated < revisionDrawListCount; thisFrame++) {
		revisionDrawList[revisionLogoFullNumDistancesCalculated].calcDistanceToCamera();
		revisionLogoFullNumDistancesCalculated++;
		if (thisFrame > 40) {
			// TODO: is this limit really needed actually, probably rather want to segment projecting/rotating
			return false;
		}
	}

	revisionLogoFullPhase = 13;
} else if (revisionLogoFullPhase == 13) {

	// outer (project)
	project_batch_unchecked(revisionLogoPointsOuter, 0, 96);

	revisionLogoFullPhase = 14;
} else if (revisionLogoFullPhase == 14) {

	// middle (project)
	project_batch_unchecked(revisionLogoPointsMiddle, 0, 96);

	revisionLogoFullPhase = 15;
} else if (revisionLogoFullPhase == 15) {

	// inner (project)
	project_batch_unchecked(revisionLogoPointsInner, 0, 52);

	revisionLogoFullPhase = 16;
} else if (revisionLogoFullPhase == 16) {

	// draw
	if (revisionDrawListCount > 0) {
		for (var i = 0; i < 2; i++) {
			var maxDistance = 0.0;
			var maxIndex = 0;
			for (var a = 0; a < revisionDrawListCount; a++) {
				var distance = revisionDrawList[a].distanceToCamera;
				if (distance > maxDistance) {
					maxIndex = a;
					maxDistance = distance;
				}
			}
			var toDraw = revisionDrawList[maxIndex];
			revisionDrawListCount--;
			revisionDrawList[maxIndex] = revisionDrawList[revisionDrawListCount];
			revisionDrawList[revisionDrawListCount] = toDraw;
			dc.setColor(toDraw.fill, Graphics.COLOR_BLACK);
			dc.fillPolygon([
				[toDraw.points[toDraw.a], toDraw.points[toDraw.a+1]],
				[toDraw.points[toDraw.b], toDraw.points[toDraw.b+1]],
				[toDraw.points[toDraw.c], toDraw.points[toDraw.c+1]],
				[toDraw.points[toDraw.d], toDraw.points[toDraw.d+1]],
			]);
			if (revisionDrawListCount < 25) {
				// keep busy or the scroller will suddenly go much faster -.-'
				rotate_batch(revisionLogoFlatPointsOuterIMMUTABLE, revisionLogoFlatPointsOuter, 0, 30-revisionDrawListCount, tmpquat);
			}
			if (revisionDrawListCount == 0) {
				return true;
			}
		}
	} else {
		// keep busy or the scroller will suddenly go much faster -.-'
		rotate_batch(revisionLogoPointsOuterIMMUTABLE, revisionLogoPointsOuter, 0, 80, revisionLogoFullQuats[0]);
	}

}
return false;
}
/*jeanine:p:i:5;p:4;a:t;x:3.75;*/
var revisionLogoFlatPointsOuterIMMUTABLE = new [48*3];
var revisionLogoFlatPointsOuter = new [48*3];
var revisionLogoFlatFacesOuter = new [16*4];
var revisionLogoFlatPointsMiddleIMMUTABLE = new [48*3];
var revisionLogoFlatPointsMiddle = new [48*3];
var revisionLogoFlatFacesMiddle = new [18*4];
var revisionLogoFlatPointsInnerIMMUTABLE = new [26*3];
var revisionLogoFlatPointsInner = new [26*3];
var revisionLogoFlatFacesInner = new [12*4];
var revisionLogoFlatDrawList = new [16+18+12];
var revisionLogoFlatDrawListCount;

function initialize_revision_logoflat()
{
	for (var a = 0; a < 48*3; a+=3) {
		revisionLogoFlatPointsOuterIMMUTABLE[a] = revisionLogoPointsOuterIMMUTABLE[a*2];
		revisionLogoFlatPointsOuterIMMUTABLE[a+1] = revisionLogoPointsOuterIMMUTABLE[a*2+1];
		revisionLogoFlatPointsOuterIMMUTABLE[a+2] = 0.0;
	}
	for (var a = 0; a < 16*4; a++) {
		revisionLogoFlatFacesOuter[a] = revisionLogoFacesOuterFront[a]/2;
	}
	for (var a = 0; a < 48*3; a+=3) {
		revisionLogoFlatPointsMiddleIMMUTABLE[a] = revisionLogoPointsMiddleIMMUTABLE[a*2];
		revisionLogoFlatPointsMiddleIMMUTABLE[a+1] = revisionLogoPointsMiddleIMMUTABLE[a*2+1];
		revisionLogoFlatPointsMiddleIMMUTABLE[a+2] = 0.0;
	}
	for (var a = 0; a < 18*4; a++) {
		revisionLogoFlatFacesMiddle[a] = revisionLogoFacesMiddleFront[a]/2;
	}
	for (var a = 0; a < 26*3; a+=3) {
		revisionLogoFlatPointsInnerIMMUTABLE[a] = revisionLogoPointsInnerIMMUTABLE[a*2];
		revisionLogoFlatPointsInnerIMMUTABLE[a+1] = revisionLogoPointsInnerIMMUTABLE[a*2+1];
		revisionLogoFlatPointsInnerIMMUTABLE[a+2] = 0.0;
	}
	for (var a = 0; a < 12*4; a++) {
		revisionLogoFlatFacesInner[a] = revisionLogoFacesInnerFront[a]/2;
	}
	for (var a = 0; a < 16+18+12; a++) {
		revisionLogoFlatDrawList[a] = new DrawListEntry();
	}
}
function revisionlogoflat(dc, badMs)
{
	dc.setColor(Graphics.COLOR_BLACK, Graphics.COLOR_BLACK);
	dc.clear();

	var poly0 = [0, 0];
	var poly1 = [0, 0];
	var poly2 = [0, 0];
	var poly3 = [0, 0];
	var poly = [poly0, poly1, poly2, poly3];

	revisionLogoFlatDrawListCount = 0;

	var rollOffset = Math.toRadians(-90.0);
	var baseTurnP = badMs/800.0;
	var baseTurnR = badMs/1000.0;
	var baseTurnY = badMs/2000.0;

	// outer
	make_quat(baseTurnP, baseTurnR + rollOffset, baseTurnY, tmpquat);
	rotate_batch(revisionLogoFlatPointsOuterIMMUTABLE, revisionLogoFlatPointsOuter, 0, 48, tmpquat);
	for (var a = 0; a < 16 * 4; a+=4) {
		var drawListEntry = revisionLogoFlatDrawList[revisionLogoFlatDrawListCount];
		revisionLogoFlatDrawListCount++;
		//drawListEntry.fill = Graphics.COLOR_PURPLE;
		drawListEntry.points = revisionLogoFlatPointsOuter;
		drawListEntry.a = revisionLogoFlatFacesOuter[a]*3;
		drawListEntry.b = revisionLogoFlatFacesOuter[a+1]*3;
		drawListEntry.c = revisionLogoFlatFacesOuter[a+2]*3;
		drawListEntry.d = revisionLogoFlatFacesOuter[a+3]*3;
		//drawListEntry.calcDistanceToCamera();
	}
	project_batch_unchecked(revisionLogoFlatPointsOuter, 0, 48);

	if (badMs > 2000) {
		baseTurnP += (badMs - 2000) / 1500.0;
		baseTurnR += (badMs - 2000) / 1800.0;
		baseTurnY += (badMs - 2000) / 2300.0;
	}

	// middle
	make_quat(baseTurnP, baseTurnR + rollOffset, baseTurnY, tmpquat);
	rotate_batch(revisionLogoFlatPointsMiddleIMMUTABLE, revisionLogoFlatPointsMiddle, 0, 48, tmpquat);
	for (var a = 0; a < 18 * 4; a+=4) {
		var drawListEntry = revisionLogoFlatDrawList[revisionLogoFlatDrawListCount];
		revisionLogoFlatDrawListCount++;
		//drawListEntry.fill = Graphics.COLOR_PURPLE;
		drawListEntry.points = revisionLogoFlatPointsMiddle;
		drawListEntry.a = revisionLogoFlatFacesMiddle[a]*3;
		drawListEntry.b = revisionLogoFlatFacesMiddle[a+1]*3;
		drawListEntry.c = revisionLogoFlatFacesMiddle[a+2]*3;
		drawListEntry.d = revisionLogoFlatFacesMiddle[a+3]*3;
		//drawListEntry.calcDistanceToCamera();
	}
	project_batch_unchecked(revisionLogoFlatPointsMiddle, 0, 48);

	if (badMs > 2000) {
		baseTurnP += (badMs - 2000) / 2300.0;
		baseTurnR += (badMs - 2000) / 3000.0;
		baseTurnY += (badMs - 2000) / 4000.0;
	}

	// inner
	make_quat(baseTurnP, baseTurnR + rollOffset, baseTurnY, tmpquat);
	rotate_batch(revisionLogoFlatPointsInnerIMMUTABLE, revisionLogoFlatPointsInner, 0, 26, tmpquat);
	for (var a = 0; a < 12 * 4; a+=4) {
		var drawListEntry = revisionLogoFlatDrawList[revisionLogoFlatDrawListCount];
		revisionLogoFlatDrawListCount++;
		//drawListEntry.fill = Graphics.COLOR_PURPLE;
		drawListEntry.points = revisionLogoFlatPointsInner;
		drawListEntry.a = revisionLogoFlatFacesInner[a]*3;
		drawListEntry.b = revisionLogoFlatFacesInner[a+1]*3;
		drawListEntry.c = revisionLogoFlatFacesInner[a+2]*3;
		drawListEntry.d = revisionLogoFlatFacesInner[a+3]*3;
		//drawListEntry.calcDistanceToCamera();
	}
	project_batch_unchecked(revisionLogoFlatPointsInner, 0, 26);

	// draw
	if (revisionLogoFlatMaxFaces < revisionLogoFlatDrawListCount) {
		revisionLogoFlatDrawListCount = revisionLogoFlatMaxFaces;
	}
	dc.setColor(Graphics.COLOR_WHITE, Graphics.COLOR_BLACK);
	for (var a = 0; a < revisionLogoFlatDrawListCount; a++) {
		var drawListEntry = revisionLogoFlatDrawList[a];
		poly0[0] = drawListEntry.points[drawListEntry.a];
		poly0[1] = drawListEntry.points[drawListEntry.a+1];
		poly1[0] = drawListEntry.points[drawListEntry.b];
		poly1[1] = drawListEntry.points[drawListEntry.b+1];
		poly2[0] = drawListEntry.points[drawListEntry.c];
		poly2[1] = drawListEntry.points[drawListEntry.c+1];
		poly3[0] = drawListEntry.points[drawListEntry.d];
		poly3[1] = drawListEntry.points[drawListEntry.d+1];
		//dc.setColor(drawListEntry.fill, Graphics.COLOR_BLACK);
		dc.fillPolygon(poly);
	}
}
/*jeanine:p:i:7;p:5;a:t;x:3.75;*/
var torusPointsIMMUTABLE = new [18*9*3];
var torusPoints = new [18*9*3];
var torusFaceLastChange = 0;
var torusFacePointX = 0;
var torusFacePointY = 0;
var torusFacePointZZ = 0;

function torus_initialize()
{
	for (var a = 0; a < 18; a++) {
		var angle = Math.toRadians(a * 20);
		var x  = Math.cos(angle);
		var z = Math.sin(angle);
		for (var b = 0; b < 9; b++) {
			var idx = a*9*3+b*3;
			angle = Math.toRadians(b * 40);
			torusPointsIMMUTABLE[idx] = (37 + 10 * Math.cos(angle)) * x;
			torusPointsIMMUTABLE[idx+1] = 10 * Math.sin(angle);
			torusPointsIMMUTABLE[idx+2] = (37 + 10 * Math.cos(angle)) * z;
		}
	}
}

function torus(dc)
{
	make_quat(0.0, badMs / 2000.0, badMs / 3000.0, tmpquat);
	rotate_batch(torusPointsIMMUTABLE, torusPoints, 0, 18*9, tmpquat);
	project_batch_unchecked(torusPoints, 0, 18*9);
	dc.setColor(Graphics.COLOR_RED, Graphics.COLOR_TRANSPARENT);
	for (var i = 0; i < 18*9*3; i += 3) {
		dc.fillCircle(torusPoints[i], torusPoints[i+1], 1.0);
	}

	//if (badMs - torusFaceLastChange > 500) {
		//torusFaceLastChange = badMs;
		//torusFacePointA = (torusFacePointA+1) % (18*9);
		torusFacePointY++;
		if (torusFacePointY == 9) {
			torusFacePointY = 0;
			torusFacePointX = (torusFacePointX + 1) % 18;
		}
	//}

	dc.setColor(Graphics.COLOR_WHITE, Graphics.COLOR_TRANSPARENT);
	/*
	var a = (torusFacePointY + torusFacePointX * 9) * 3;
	var b = (((torusFacePointY + 1) % 9) + torusFacePointX * 9) * 3;
	var c = (torusFacePointY + ((torusFacePointX + 1) % 18) * 9) * 3;
	var d = (((torusFacePointY + 1) % 9) + ((torusFacePointX + 1) % 18) * 9) * 3;
	dc.fillPolygon([
		[torusPoints[a], torusPoints[a+1]],
		[torusPoints[b], torusPoints[b+1]],
		[torusPoints[d], torusPoints[d+1]],
		[torusPoints[c], torusPoints[c+1]],
	]);
	*/

	torusFacePointZZ = (torusFacePointZZ + 1) % 18;
	for (var z = 0; z < 9; z++) {
		var a = (z + torusFacePointZZ * 9) * 3;
		var b = (((z + 1) % 9) + torusFacePointZZ * 9) * 3;
		var c = (z + ((torusFacePointZZ + 1) % 18) * 9) * 3;
		var d = (((z + 1) % 9) + ((torusFacePointZZ + 1) % 18) * 9) * 3;
		dc.fillPolygon([
			[torusPoints[a], torusPoints[a+1]],
			[torusPoints[b], torusPoints[b+1]],
			[torusPoints[d], torusPoints[d+1]],
			[torusPoints[c], torusPoints[c+1]],
		]);
	}
}
/*jeanine:p:i:9;p:10;a:t;x:2.00;*/
var scrollerBmLetter;
var scrollerBmAll;
var scrollerText = "Echtzeit         spacepigs         Slipstream         NDF         Ninjadev         Desire         SpeckDrumm         Moonbase         scenesat         BaaS".toCharArray();
var scrollerInitialDraw = true;
var scrollerAngle = 0;

function scroller_initialize(dc)
{
}

function scroller(dc)
{
	//dc.setColor(Graphics.COLOR_BLACK, Graphics.COLOR_BLACK);
	//dc.clear();
	var rr2 = dc.getWidth() / 2;
	dc.setColor(Graphics.COLOR_WHITE, Graphics.COLOR_TRANSPARENT);
	if (scrollerInitialDraw) {
		scrollerInitialDraw = false;
		dc.drawCircle(rr2, rr2, rr2-9);
		dc.setPenWidth(18);
		dc.setColor(Graphics.COLOR_BLACK, Graphics.COLOR_WHITE);
		dc.setPenWidth(16);
		dc.drawArc(rr2, rr2, rr2-9, Graphics.ARC_CLOCKWISE, 180, 0);
	} else {
		dc.setPenWidth(18);
		dc.drawArc(rr2, rr2, rr2-9, Graphics.ARC_CLOCKWISE, 0, -180);
	}
	dc.setColor(Graphics.COLOR_BLACK, Graphics.COLOR_TRANSPARENT);
	scrollerAngle += 3;
	for (var i = 0; i < scrollerText.size(); i++) {
		var angle = (i * 6.0 - scrollerAngle + 10).toNumber();
		var c = scrollerText[i];
		if (angle > 0) {
			break;
		}
		if (angle > -180 && c != ' ') {
			angle = Math.toRadians(angle);
			var x = dc.getWidth() * (.5 + .46 * Math.cos(angle));
			var y = dc.getHeight() * (.5 - .46 * Math.sin(angle));
			dc.drawText(x, y, Graphics.FONT_XTINY, c.toString().toUpper(), Graphics.TEXT_JUSTIFY_CENTER | 4);
		}
	}
}
/*jeanine:p:i:10;p:7;a:t;x:3.75;*/
var cubeBoingFan = [
	[120, 120],
	[110, 32],
	[144, 35],
	[174, 51],
	[196, 76],
	[207, 110],
	[204, 144],
	[188, 174],
	[162, 196],
	[129, 207],
	[95, 204],
	[65, 188],
	[43, 162],
	[32, 129],
	[35, 95],
	[51, 65],
	[77, 43],
	[110, 32],
];
/*
  +4--------+7
 /|        /|
+0--------+3|
| |       | |
|5+-------|-+6
|/        |/
+1--------+2
*/
var cubesPointsIMMUTABLE = [
	-20.0, 20.0, 20.0,
	-20.0, 20.0, -20.0,
	20.0, 20.0, -20.0,
	20.0, 20.0, 20.0,
	-20.0, -20.0, 20.0,
	-20.0, -20.0, -20.0,
	20.0, -20.0, -20.0,
	20.0, -20.0, 20.0
];
var cubesPoints = new [8*3];
var cubesFaces = [
	0, 3, 2, 1, // F (0)
	4, 7, 3, 0, // U (1)
	5, 6, 7, 4, // B (2)
	1, 2, 6, 5, // D (3)
	4, 0, 1, 5, // L (4)
	3, 7, 6, 2, // R (5)
];
var cubesFacesDots = new [6];
var cubesLines = [
	0, 4, 4, 7, 7, 3, 3, 0,
	1, 5, 5, 6, 6, 2, 2, 1,
	0, 1, 4, 5, 7, 6, 3, 2,
];
var cubesLinesToFaces = [ // 2 per line
	1, 4, 1, 2, 1, 5, 1, 0,
	3, 4, 2, 3, 5, 3, 0, 3,
	0, 4, 2, 4, 2, 5, 0, 5,
];
var cubesPointsToFaces = [ // 3 per point
	0, 1, 4,
	0, 3, 4,
	0, 3, 5,
	0, 1, 5,
	1, 2, 4,
	2, 3, 4,
	2, 3, 5,
	1, 2, 5,
];
var cubePitch = 0.0;
var cubeRoll = 0.0;
var cubeYaw = 0.0;
var cubeLineLerp = 0.0;
var cubeArcDeg = 180;
var cubeArcPhase = 0;

function cubes(dc, goodS, badMs)
{
	cubePitch += 0.07;
	if (goodS >= 6) {
		cubeRoll += .04;
		cubeYaw += .03;
	}
	dc.setColor(Graphics.COLOR_BLACK, Graphics.COLOR_BLACK);
	dc.clear();

	make_quat(cubePitch, cubeRoll, cubeYaw, tmpquat);
	rotate_batch(cubesPointsIMMUTABLE, cubesPoints, 0, 8, tmpquat);
	for (var i = 0; i < 6; i++) {
		cubesFacesDots[i] = face_normal_dot_rayvec_normalized(cubesPoints, cubesFaces, i*4);
	}
	project_batch_unchecked(cubesPoints, 0, 8);

	if (goodS < 6) {
		dc.setPenWidth(2);
		dc.setColor(Graphics.COLOR_PURPLE, Graphics.COLOR_TRANSPARENT);
		var npoints = goodS - 1;
		npoints = npoints < 1 ? 1 : npoints > 4 ? 4 : npoints;
		for (var a = 4; a < 4 + npoints; a++) {
			dc.fillCircle(cubesPoints[a*3], cubesPoints[a*3+1], 4);
		}
	} else if (goodS < 15) {
		dc.setPenWidth(2);
		dc.setColor(Graphics.COLOR_PURPLE, Graphics.COLOR_TRANSPARENT);
		for (var a = 0; a < 8; a++) {
			var z = a*3;
			if (cubesFacesDots[cubesPointsToFaces[z]] > 0 || cubesFacesDots[cubesPointsToFaces[z+1]] > 0 || cubesFacesDots[cubesPointsToFaces[z+2]] > 0) {
				dc.fillCircle(cubesPoints[a*3], cubesPoints[a*3+1], 4);
			}
		}
		if (goodS > 10) {
			if (cubeLineLerp < 1.0) {
				cubeLineLerp += 0.02;
			} else {
				cubeLineLerp = 1.0;
			}
			for (var i = 0; i < 24; i+=2) {
				if (cubesFacesDots[cubesLinesToFaces[i]] > 0 || cubesFacesDots[cubesLinesToFaces[i+1]] > 0) {
					var l1 = cubesLines[i]*3;
					var l2 = cubesLines[i+1]*3;
					var a = cubesPoints[l1];
					var b = cubesPoints[l1+1];
					var c = cubesPoints[l2];
					var d = cubesPoints[l2+1];
					c = lerp(a, c, cubeLineLerp);
					d = lerp(b, d, cubeLineLerp);
					dc.drawLine(a, b, c, d);
				}
			}
		}
	} else /*if (goodS < 26)*/ {
		for (var i = 0; i < 6; i++) {
			var col = cubesFacesDots[i];
			if (col > 0.0) {
				if (col > 1.0) {
					col = 1.0;
				}
				var red = ((0.3 + 0.7 * col) * 0xFF).toNumber() << 16;
				dc.setColor(red, Graphics.COLOR_BLACK);
				var z = i * 4;
				var a = cubesFaces[z]*3;
				var b = cubesFaces[z+1]*3;
				var c = cubesFaces[z+2]*3;
				var d = cubesFaces[z+3]*3;
				dc.fillPolygon([
					[cubesPoints[a], cubesPoints[a+1]],
					[cubesPoints[b], cubesPoints[b+1]],
					[cubesPoints[c], cubesPoints[c+1]],
					[cubesPoints[d], cubesPoints[d+1]]
				]);
			}
		}
		if (goodS >= 20) {
			var rr2 = dc.getWidth() / 2;
			dc.setPenWidth(18);
			if (cubeArcPhase == 0) {
				cubeArcDeg -= 10;
				if (cubeArcDeg < -179) {
					cubeArcDeg = -179;
				}
				dc.setColor(Graphics.COLOR_WHITE, Graphics.COLOR_WHITE);
				dc.drawArc(rr2, rr2, rr2-9, Graphics.ARC_CLOCKWISE, 180, cubeArcDeg);
				if (cubeArcDeg == -179) {
					cubeArcDeg = 180;
					cubeArcPhase = 1;
				}
			} else if (cubeArcPhase == 1) {
				dc.setColor(Graphics.COLOR_WHITE, Graphics.COLOR_WHITE);
				dc.drawCircle(rr2, rr2, rr2-9);

				cubeArcDeg -= 10;
				if (cubeArcDeg < 0) {
					cubeArcDeg = 0;
				}
				dc.setColor(Graphics.COLOR_BLACK, Graphics.COLOR_WHITE);
				dc.setPenWidth(14);
				dc.drawArc(rr2, rr2, rr2-9, Graphics.ARC_CLOCKWISE, 180, cubeArcDeg);
			}
			var fanProgress = cubeArcPhase == 0 ? (1.0-(cubeArcDeg+180.0)/360.0)*2.0/3.0 : (2.0/3.0+(180.0-cubeArcDeg)/180.0/3.0);
			fanProgress = (fanProgress*16).toNumber();
			dc.setColor(Graphics.COLOR_WHITE, Graphics.COLOR_WHITE);
			dc.fillPolygon(cubeBoingFan.slice(0, 3 + fanProgress));
		}
	}
}
/*jeanine:p:i:2;p:6;a:r;x:13.00;*/

const t = 125;
const B_3 = 246;
const C_3 = 130;
const G_3 = 196;
const AS3 = 233;
const DS4 = 311;
const FS4 = 370;
const G_4 = 392;
const GS4 = 415;
const F_4 = 349;
const F_5 = 698;
const G_5 = 784;
const C_4 = 262;
const AS4 = 466;
const B_4 = 494;
const C_5 = 523;
const CS5 = 554;
const D_5 = 587;
const DS5 = 622;
const FS5 = 740;
const GS5 = 831;
const C_6 = 1046;

const tones = [
	[
		new Attention.ToneProfile(C_4, t*2),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_4, t*1),
		new Attention.ToneProfile(C_5, t*2),
		new Attention.ToneProfile(C_4, t*2),
		new Attention.ToneProfile(C_3, t*1),
		new Attention.ToneProfile(0, t*3),
		new Attention.ToneProfile(C_3, t*1),
		new Attention.ToneProfile(0, t*3),
		new Attention.ToneProfile(C_5, t*1),
		new Attention.ToneProfile(C_5, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_5, t*2),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(AS4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(G_4, t*3),
		new Attention.ToneProfile(G_4, t*1),
		new Attention.ToneProfile(AS4, t*2),
		new Attention.ToneProfile(C_5, t*2),
		new Attention.ToneProfile(C_4, t*2),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_4, t*1),
		new Attention.ToneProfile(C_5, t*2),
		new Attention.ToneProfile(C_4, t*2),
		new Attention.ToneProfile(C_3, t*1),
		new Attention.ToneProfile(0, t*3),
		new Attention.ToneProfile(C_3, t*1),
		new Attention.ToneProfile(0, t*3),
		new Attention.ToneProfile(C_5, t*1),
		new Attention.ToneProfile(C_4, t*2),
		new Attention.ToneProfile(C_4, t*1),
		new Attention.ToneProfile(DS4, t*2),
		new Attention.ToneProfile(C_4, t*1),
		new Attention.ToneProfile(F_4, t*2),
		new Attention.ToneProfile(C_4, t*1),
		new Attention.ToneProfile(G_4, t*2),
		new Attention.ToneProfile(AS4, t*2),
		new Attention.ToneProfile(B_4, t*2),
	],
	[
		new Attention.ToneProfile(C_5, t*4),
		new Attention.ToneProfile(C_4, t*1),
		new Attention.ToneProfile(C_4, t*2),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_4, t*4),
		new Attention.ToneProfile(AS4, t*2),
		new Attention.ToneProfile(B_4, t*2),
		new Attention.ToneProfile(C_5, t*3),
		new Attention.ToneProfile(AS4, t*1),
		new Attention.ToneProfile(G_4, t*2),
		new Attention.ToneProfile(G_4, t*1),
		new Attention.ToneProfile(AS4, t*3),
		new Attention.ToneProfile(G_4, t*2),
		new Attention.ToneProfile(F_4, t*2),
		new Attention.ToneProfile(G_4, t*2),
		new Attention.ToneProfile(F_4, t*13),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(F_4, t*2),
		new Attention.ToneProfile(G_4, t*3),
		new Attention.ToneProfile(G_4, t*1),
		new Attention.ToneProfile(F_4, t*3),
		new Attention.ToneProfile(F_4, t*1),
		new Attention.ToneProfile(DS4, t*3),
		new Attention.ToneProfile(DS4, t*1),
		new Attention.ToneProfile(C_4, t*4),
	],
	[
		new Attention.ToneProfile(C_5, t*4),
		new Attention.ToneProfile(C_4, t*1),
		new Attention.ToneProfile(C_4, t*2),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_4, t*4),
		new Attention.ToneProfile(AS4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(B_4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_5, t*3),
		new Attention.ToneProfile(AS4, t*1),
		new Attention.ToneProfile(G_4, t*2),
		new Attention.ToneProfile(G_4, t*1),
		new Attention.ToneProfile(AS4, t*3),
		new Attention.ToneProfile(G_4, t*2),
		new Attention.ToneProfile(F_4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(G_4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(F_4, t*4),
		new Attention.ToneProfile(F_5, t*1),
		new Attention.ToneProfile(F_4, t*1),
		new Attention.ToneProfile(F_5, t*1),
		new Attention.ToneProfile(F_4, t*1),
		new Attention.ToneProfile(F_5, t*1),
		new Attention.ToneProfile(F_4, t*4),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(F_4, t*2),
		new Attention.ToneProfile(G_4, t*3),
		new Attention.ToneProfile(G_5, t*1),
		new Attention.ToneProfile(F_4, t*3),
		new Attention.ToneProfile(F_5, t*1),
		new Attention.ToneProfile(DS4, t*3),
		new Attention.ToneProfile(DS5, t*1),
		new Attention.ToneProfile(C_4, t*4),
	],
	[
		new Attention.ToneProfile(C_4, t*3),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(DS4, t*1),
		new Attention.ToneProfile(F_4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(G_4, t*7),
		new Attention.ToneProfile(G_4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(AS4, t*3),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(G_4, t*1),
		new Attention.ToneProfile(AS4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_5, t*3),
		new Attention.ToneProfile(AS4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(G_4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(F_4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_4, t*3),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(DS4, t*1),
		new Attention.ToneProfile(F_4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(G_4, t*4),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(G_4, t*1),
		new Attention.ToneProfile(F_4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(DS4, t*2),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_4, t*8),
		new Attention.ToneProfile(G_3, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(AS3, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(B_3, t*1),
		new Attention.ToneProfile(0, t*1),
	],
	[
		new Attention.ToneProfile(C_4, t*3),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(DS4, t*1),
		new Attention.ToneProfile(F_4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(G_4, t*7),
		new Attention.ToneProfile(DS5, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(F_5, t*3),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(DS5, t*1),
		new Attention.ToneProfile(F_5, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(G_5, t*3),
		new Attention.ToneProfile(F_5, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(DS5, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_5, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_4, t*3),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(DS4, t*1),
		new Attention.ToneProfile(F_4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(G_4, t*4),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(G_4, t*1),
		new Attention.ToneProfile(F_4, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(DS4, t*2),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_4, t*8),
		new Attention.ToneProfile(G_3, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(AS3, t*1),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(B_3, t*1),
		new Attention.ToneProfile(0, t*1),
	],
	[
		new Attention.ToneProfile(C_5, t*4),
		new Attention.ToneProfile(C_4, t*1),
		new Attention.ToneProfile(C_4, t*2),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_4, t*4),
		new Attention.ToneProfile(AS4, t*2),
		new Attention.ToneProfile(B_4, t*2),
		new Attention.ToneProfile(C_5, t*3),
		new Attention.ToneProfile(AS4, t*1),
		new Attention.ToneProfile(G_4, t*2),
		new Attention.ToneProfile(G_4, t*1),
		new Attention.ToneProfile(AS4, t*3),
		new Attention.ToneProfile(G_4, t*2),
		new Attention.ToneProfile(F_4, t*2),
		new Attention.ToneProfile(G_4, t*2),
		new Attention.ToneProfile(F_4, t*14),
		new Attention.ToneProfile(AS4, t*2),
		new Attention.ToneProfile(C_5, t*4),
		new Attention.ToneProfile(AS4, t*4),
		new Attention.ToneProfile(DS5, t*4),
		new Attention.ToneProfile(D_5, t*4),
	],
	[
		new Attention.ToneProfile(C_5, t*4),
		new Attention.ToneProfile(C_6, t*1),
		new Attention.ToneProfile(C_5, t*1),
		new Attention.ToneProfile(C_6, t*1),
		new Attention.ToneProfile(C_5, t*1),
		new Attention.ToneProfile(C_4, t*3),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_4, t*4),
		new Attention.ToneProfile(C_5, t*3),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_5, t*1),
		new Attention.ToneProfile(C_5, t*2),
		new Attention.ToneProfile(0, t*1),
		new Attention.ToneProfile(C_5, t*2),
	]
];
var musicPattern = 0;
var musicDrawable;

function music_initialize()
{
	musicDrawable = new Rez.Drawables.transrect();
}

function music() as Void
{
	Attention.playTone({:toneProfile=>tones[musicPattern]});
	musicPattern++;
	if (musicPattern < tones.size()) {
		WatchUi.animate(musicDrawable, :locX, WatchUi.ANIM_TYPE_LINEAR, 0, 1000, t*64/1000.0, method(:music));
	}
}
/*jeanine:p:i:6;p:0;a:t;x:769.00;*/
var boingFrames;
var boingframe = 0;

var epoch;
var started = false;

	function initialize()
	{
		View.initialize();
		boingFrames = [
			new Rez.Drawables.boing0(),
			new Rez.Drawables.boing1(),
			new Rez.Drawables.boing2(),
			new Rez.Drawables.boing3(),
			new Rez.Drawables.boing4(),
			new Rez.Drawables.boing5(),
			new Rez.Drawables.boing6(),
			new Rez.Drawables.boing7(),
			new Rez.Drawables.boing8(),
			new Rez.Drawables.boing9(),
			new Rez.Drawables.boing10(),
			new Rez.Drawables.boing11(),
			new Rez.Drawables.boing12(),
			new Rez.Drawables.boing13(),
			new Rez.Drawables.boing14(),
			new Rez.Drawables.boing15(),
			new Rez.Drawables.boing16(),
			new Rez.Drawables.boing17(),
			new Rez.Drawables.boing18(),
			new Rez.Drawables.boing19(),
		];
		rbbslogo = new WatchUi.Bitmap({:rezId=>Rez.Drawables.rbbslogo,:locX=>0,:locY=>0});
		initialize_revision_logo();
		initialize_revision_logoflat();
		torus_initialize();
		music_initialize();
	}

	function timerTick() as Void
	{
		if (!started) {
			var now = Time.now().value();
			if (epoch < now) {
				music();/*jeanine:r:i:2;*/
				epoch = now;
				started = true;
			}
		} else {
			badMs += 50;
			WatchUi.requestUpdate();
		}
	}

	// Load your resources here
	function onLayout(dc)
	{
		epoch = Time.now().value() + 3;
		new Timer.Timer().start(method(:timerTick), 50, true);
	}

	function onShow()
	{
	}

var revisionLogoFullTimeLeft = -1;
var boingBallFadeCircleRadius = 0;
var flatRevStartBadMs = 0;
var revisionLogoFlatMaxFaces = (16+18+12)*2;

	// Update the view
	function onUpdate(dc)
	{
		if (!started) {
			dc.setColor(Graphics.COLOR_BLACK, Graphics.COLOR_BLACK);
			dc.clear();
			rbbslogo.draw(dc);
			return;
		}

		var goodS = Time.now().value() - epoch;

		if (goodS < 23) {
			cubes(dc, goodS, badMs);
		} else if (goodS < 50) {
			scroller(dc);
			if (goodS > 30) {
				if (revisionLogoFullTimeLeft == -1) {
					make_quat(0.0, Math.PI/-2-.3, -0.75, revisionLogoFullQuats[0]);
					make_quat(0.0, Math.PI/-2-.3, -0.75, revisionLogoFullQuats[1]);
					make_quat(0.0, Math.PI/-2-.3, -0.75, revisionLogoFullQuats[2]);
					revisionLogoFullTimeLeft = -2;
				} else if (revisionLogoFullTimeLeft > 0) {
					revisionLogoFullTimeLeft -= 50;
					if (revisionLogoFullTimeLeft == 0) {
						revisionLogoFullPhase = 0;
						make_quat(0.0, Math.PI/-2+.6, 0.42, revisionLogoFullQuats[0]);
						make_quat(0.5, Math.PI/-2+.6, -2.4, revisionLogoFullQuats[1]);
						make_quat(0.8, Math.PI/-2+.7, 0.7, revisionLogoFullQuats[2]);
					}
				}
				var justDone = revisionlogofull(dc);
				if (justDone) {
					revisionLogoFullTimeLeft = 3500;
				}
			} else {
				boingframe = (boingframe + 1) % boingFrames.size();
				boingFrames[boingframe].draw(dc);
				if (goodS > 28) {
					boingBallFadeCircleRadius += 3;
					var outerRadius = dc.getWidth()/2-22;
					var middleRadius = outerRadius/2;
					var radius = outerRadius - boingBallFadeCircleRadius;
					if (radius < middleRadius) {
						radius = middleRadius;
					}
					dc.setPenWidth((outerRadius - radius)*2);
					dc.setColor(Graphics.COLOR_BLACK, Graphics.COLOR_BLACK);
					dc.drawCircle(dc.getWidth()/2, dc.getHeight()/2, radius);
				}
			}
		} else {
			var creds = goodS < 53;
			if (!creds && flatRevStartBadMs == 0) {
				flatRevStartBadMs = badMs;
			}
			revisionlogoflat(dc, creds ? 0 : (badMs - flatRevStartBadMs));
			if (creds) {
				dc.setColor(Graphics.COLOR_BLUE, Graphics.COLOR_BLACK);
				dc.drawText(dc.getWidth() / 2, dc.getHeight() / 2 - 15, Graphics.FONT_TINY, "music: Steffest", Graphics.TEXT_JUSTIFY_CENTER|4);
				dc.drawText(dc.getWidth() / 2, dc.getHeight() / 2 + 15, Graphics.FONT_TINY, "code: yugecin", Graphics.TEXT_JUSTIFY_CENTER|4);
			} else if (goodS > 57) {
				if (revisionLogoFlatMaxFaces < -5) {
					System.exit();
				}
				revisionLogoFlatMaxFaces--;
			}
		}

		//torus(dc);
		//revisionlogofull(dc);
		//revisionlogoflat(dc);

		/*
		dc.setColor(Graphics.COLOR_BLUE, Graphics.COLOR_BLACK);
		dc.drawText(dc.getWidth() / 2, dc.getHeight() / 2 + 20, Graphics.FONT_XTINY, "a " + badMs, Graphics.TEXT_JUSTIFY_CENTER);
		dc.drawText(dc.getWidth() / 2, dc.getHeight() / 2 + 80, Graphics.FONT_XTINY, "d " + goodS * 1000, Graphics.TEXT_JUSTIFY_CENTER);
		dc.drawText(dc.getWidth() / 2, dc.getHeight() / 2 + 60, Graphics.FONT_XTINY, "mp " + musicPattern, Graphics.TEXT_JUSTIFY_CENTER);
		*/
	}

	function project_batch_unchecked(points, at, numPoints)
	{
		var end = at + numPoints * 3;
		for (var a = at; a < end; a += 3) {
			var x = 0.4999999702 * points[a+1] + 0.7140740156 * points[a] + 49.99999619;
			var y = -1.26946485 * points[a+2] + 0.5 * points[a+1] + 50.0;
			var z = points[a+1] + 100.0;
			var f = 1.0 / z;
			//points[a+0] = x * f * 240.0; //640.0;
			points[a+0] = x * f * 300.0 - 30.0; //640.0;
			points[a+1] = y * f * 168.0 + 36.0; //448.0;
			points[a+2] = z;
		}
	}

	function rotate_batch(pointsSrc, pointsDst, at, numPoints, quat)
	{
		var n1 = quat[0] * 2.0;
		var n2 = quat[1] * 2.0;
		var n3 = quat[2] * 2.0;
		var n4 = quat[0] * n1;
		var n5 = quat[1] * n2;
		var n6 = quat[2] * n3;
		var n7 = quat[0] * n2;
		var n8 = quat[0] * n3;
		var n9 = quat[1] * n3;
		var n10 = quat[3] * n1;
		var n11 = quat[3] * n2;
		var n12 = quat[3] * n3;
		var end = at + numPoints * 3;
		for (var a = at; a < end; a += 3) {
			var x = (1.0 - (n5 + n6)) * pointsSrc[a] + (n7 - n12) * pointsSrc[a+1] + (n8 + n11) * pointsSrc[a+2];
			var y = (n7 + n12) * pointsSrc[a] + (1.0 - (n4 + n6)) * pointsSrc[a+1] + (n9 - n10) * pointsSrc[a+2];
			var z = (n8 - n11) * pointsSrc[a] + (n9 + n10) * pointsSrc[a+1] + (1.0 - (n4 + n5)) * pointsSrc[a+2];
			pointsDst[a] = x;
			pointsDst[a+1] = y;
			pointsDst[a+2] = z;
		}
	}

	function make_quat(pitch, roll, yaw, out)
	{
		var cy = Math.cos(yaw * .5);
		var sy = Math.sin(yaw * .5);
		var cr = Math.cos(roll * .5);
		var sr = Math.sin(roll * .5);
		var cp = Math.cos(pitch * .5);
		var sp = Math.sin(pitch * .5);

		out[3] = cy * cr * cp + sy * sr * sp; // w
		out[0] = cy * sr * cp - sy * cr * sp; // x
		out[1] = cy * cr * sp + sy * sr * cp; // y
		out[2] = sy * cr * cp - cy * sr * sp; // z
	}

	function face_normal_dot_rayvec(points, faces, faceIndex) as Lang.Float
	{
		var b = faces[faceIndex]*3;
		var a = faces[faceIndex+1]*3;
		var c = faces[faceIndex+2]*3;
		var ax = points[a];
		var ay = points[a+1];
		var az = points[a+2];
		var bmax = points[b] - ax;
		var bmay = points[b+1] - ay;
		var bmaz = points[b+2] - az;
		var cmax = points[c] - ax;
		var cmay = points[c+1] - ay;
		var cmaz = points[c+2] - az;
		var normx = bmay * cmaz - bmaz * cmay;
		var normy = bmaz * cmax - bmax * cmaz;
		var normz = bmax * cmay - bmay * cmax;
		var rvx = points[a];
		var rvy = points[a+1] - campos_y;
		var rvz = points[a+2];

		var dot = normx * rvx + normy * rvy + normz * rvz;
		if (dot == 0.0) {
			return 0.0;
		}
		return normx * rvx + normy * rvy + normz * rvz;
	}

	function face_normal_dot_rayvec_normalized(points, faces, faceIndex) as Lang.Float
	{
		var b = faces[faceIndex]*3;
		var a = faces[faceIndex+1]*3;
		var c = faces[faceIndex+2]*3;
		var ax = points[a];
		var ay = points[a+1];
		var az = points[a+2];
		var bmax = points[b] - ax;
		var bmay = points[b+1] - ay;
		var bmaz = points[b+2] - az;
		var cmax = points[c] - ax;
		var cmay = points[c+1] - ay;
		var cmaz = points[c+2] - az;
		var normx = bmay * cmaz - bmaz * cmay;
		var normy = bmaz * cmax - bmax * cmaz;
		var normz = bmax * cmay - bmay * cmax;
		var rvx = points[a];
		var rvy = points[a+1] - campos_y;
		var rvz = points[a+2];

		var dot = normx * rvx + normy * rvy + normz * rvz;
		if (dot == 0.0) {
			return 0.0;
		}
		var normd = Math.sqrt(normx * normx + normy * normy + normz * normz);
		var rvd = Math.sqrt(rvx * rvx + rvy * rvy + rvz * rvz);
		return normx / normd * rvx / rvd + normy / normd * rvy / rvd + normz / normd * rvz / rvd;
	}

	function lerp(a, b, x)
	{
		return a + (b - a) * x;
	}
}
