#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\lights.h"

StructuredBuffer<DirLight> g_dir_lights : register(t0, space1);

VertexTIOut main(uint id : SV_VertexID, uint instance_id : SV_InstanceID)
{
  VertexTIOut vout;
  
  DirLight light = g_dir_lights[instance_id];
  bool scattering = light.scatt_density > 0.0f && light.scatt_multiplier > 0.0f;
  
  vout.uv = float2((id << 1) & 2, id & 2);
  vout.pos_h = float4(vout.uv * float2(2.0f,-2.0f) + float2(-1.0f,1.0f), scattering ? 0.0f : -10000.0f, 1.0f);
  vout.instance_id = instance_id;
  return vout;
}