#include "data\\shaders\\common.h"
#include "data\\shaders\\pbd\\pbd_common.h"
#include "data\\shaders\\input_formats.h"

cbuffer Constant : register(b0, space4)
{
  uint start_idx;
};

StructuredBuffer<Particle> particles : register(t0, space0);
StructuredBuffer<uint16_t> particle_indices : register(t1, space0);

StructuredBuffer<uint16_t> mesh_indices : register(t2, space0);
StructuredBuffer<VertexPNTIn> mesh_verts : register(t3, space0);

VertexPPNTOut main(uint id : SV_VertexID)
{
	VertexPPNTOut vout;

  Particle particle = particles[start_idx+particle_indices[id]];
  VertexPNTIn vert = mesh_verts[mesh_indices[id]];
  
  float3 world_pos = float3(particle.p_x,particle.p_y,particle.p_z);
  
  vout.pos_w = world_pos;
  vout.pos_v = mul(float4(world_pos,1.0f), g_view).xyz;
  
  float4 clip_pos = mul(float4(world_pos, 1.0f), g_view_proj);
  vout.pos_h = clip_pos;
  
  float3 normal = normalize(particle.normal);
  vout.normal = mul(float4(normalize(normal), 0.0f), g_view).xyz;
  
  vout.uv = vert.uv;
  vout.mat_index = particle.mat_index;
  
  //if (particle.flags > 0)
  //  vout.pos_h = float4(0,0,0,0)/0.0f;
  
  return vout;
}