#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"

Texture2D g_depth : register(t0);
Texture2D g_half_depth : register(t1);
Texture2D g_volumetric_light : register(t2);

SamplerState g_sam_point : register(s1);
SamplerState g_sam_linear : register(s3);

float4 main(VertexTOut pin) : SV_Target
{
  float2 lowres_size = g_screen_size / 2.0f;
  const uint2 pixel = pin.uv * g_screen_size;

  float2 texel_size = 1.0f / g_screen_size;
  float2 lowres_texel_size = 1.0f / lowres_size;

  float2 uv = pin.uv;

#if 0
  float max_angle = 3.14159f;
  float rand = Noise(pin.uv)* max_angle;
  float2 dir = normalize(float2(sin(rand),cos(rand)))*0.5f;

  float2 uv00 = uv + dir*lowres_texel_size;
  float2 uv10 = uv - dir*lowres_texel_size;
  float2 uv01 = uv + float2(-dir.y,dir.x)*lowres_texel_size;
  float2 uv11 = uv + float2(dir.y,-dir.x)*lowres_texel_size;
#else
  float2 uv00 = uv;
  float2 uv10 = uv + float2(lowres_texel_size.x, 0.0f);
  float2 uv01 = uv + float2(lowres_texel_size.x, lowres_texel_size.y);
  float2 uv11 = uv + float2(lowres_texel_size.x, lowres_texel_size.y);
#endif

  float4 fog_00 = g_volumetric_light.Sample(g_sam_linear, uv00);
  float4 fog_10 = g_volumetric_light.Sample(g_sam_linear, uv10);
  float4 fog_01 = g_volumetric_light.Sample(g_sam_linear, uv01);
  float4 fog_11 = g_volumetric_light.Sample(g_sam_linear, uv11);

  float4 d = float4(
    fog_00.w,
    fog_10.w,
    fog_01.w,
    fog_11.w
  );

  float min_d = min(min(min(d.x,d.y),d.z),d.w);
  float max_d = max(max(max(d.x,d.y),d.z),d.w);
  float diff_d = max(0.0f,max_d - min_d);
  float avg = dot(d,0.25.xxxx);
  float3 color = 0.0f.xxx;

  if (abs(diff_d/avg) < 0.1f)
  {
    color = g_volumetric_light.Sample(g_sam_linear, uv).xyz;
  }
  else
  {
    float depth_highres = g_depth.Sample(g_sam_point, pin.uv).x;
    depth_highres = ScreenToView(float4(0.0f,0.0f,depth_highres,1.0)).x;

    float4 dd = max(0.0f, d - depth_highres.xxxx);
    float4 w = 1.0f.xxxx / (dd + 0.000001f.xxxx);
    float sumw = w.x + w.y + w.z + w.w;

    color += fog_00.xyz * w.x;
    color += fog_10.xyz * w.y;
    color += fog_01.xyz * w.z;
    color += fog_11.xyz * w.w;
    color /= sumw;

    //color = abs(diff_d/avg).xxx;
  }

  //color = g_volumetric_light.Sample(g_sam_linear, pin.uv).xyz;
  return float4(color,1.0f);
}
