#include "data\\shaders\\particles\\particles_common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\FastNoiseLite.h"

RWStructuredBuffer<Particle> particles : register(u0);

[numthreads(8,1,1)]
void main(uint3 dispatch_thread_id  : SV_DispatchThreadID)
{
  fnl_state noise = fnlCreateState();
  noise.noise_type = g_noise_type;
  noise.seed = g_seed;
  noise.frequency = g_frequency;

  uint index = dispatch_thread_id.x;

  if (g_reset)
  {
    Particle p;
    p.pos.x = fnlGetNoise2D(noise, (float)index, 0.0f);
    p.pos.y = fnlGetNoise2D(noise, (float)index + 1000.0f, 0.0f);
    p.pos.z = fnlGetNoise2D(noise, (float)index + 4000.0f, 0.0f);
    p.pos *= g_extent;
    p.size = 50.0f;
    p.heading = float3(1.0f,0.0f,0.0f);
    p.pad = 0.0f;

    particles[index] = p;
  }
  else
  {
    Particle p = particles[index];
    float3 pos = p.pos;
    float3 v = float3(0,0,0);

    v.x = fnlGetNoise3D(noise, pos.x, pos.y, pos.z);
    v.y = fnlGetNoise3D(noise, pos.x+2000.0f, pos.y+1000.0f, pos.z);
    v.z = fnlGetNoise3D(noise, pos.x+5000.0f, pos.y+3000.0f, pos.z+1000.0f);
    p.heading = normalize(v);
    p.pos = pos + v*g_speed*g_delta_time;
    p.size = lerp(200.0f, 10.0f,length(v));
    particles[index] = p;
  }
}
