#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\lights.h"

StructuredBuffer<CullableLight> g_cullable_lights : register(t1, space1);
StructuredBuffer<uint2> g_light_grid : register(t2, space1);
StructuredBuffer<uint> g_light_index : register(t3, space1);

SamplerState g_sam_point : register(s0);
SamplerState g_sam_linear : register(s2);
SamplerComparisonState g_sam_shadow : register(s6);

PixelCNOut main(VertexPNTOut pin)
{
  PixelCNOut pout;

  float2 p = pin.uv*2.0 - 1.0;

  if (length(p) > 0.99)
    discard;

  float3 color = g_dust_color;

  if (g_num_cullable_lights > 0)
  {
    float2 pos_xy = pin.pos_h.xy;
    uint grid_index = GridIndex(pos_xy, g_screen_size.x);
    uint num_lights = g_light_grid[grid_index].y;
    uint offset = g_light_grid[grid_index].x;

    for (uint i = 0; i < num_lights; ++i)
    {
      CullableLight light = g_cullable_lights[g_light_index[offset+i]];

      if (light.type > 1)
      {
        color += spot_light_falloff(light, pin.pos_v)*20.0;
      }
      else
      {
        float3 light_direction = light.position - pin.pos_v;
        float light_dist = length(light_direction);
        light_direction /= light_dist;
        color += point_light_falloff(light_dist, light.radius)*2.0;
      }
    }
  }

  pout.color = float4(color,1.0);
  pout.normal = float4(pin.normal, pin.pos_v.z);
  return pout;
}
