#include "data\\shaders\\common.h"
#include "data\\shaders\\effects\\pixel_sort_common.h"

RWStructuredBuffer<RangeColor> g_range_buff : register(u0, space4);
Texture2D g_input : register(t0);
Texture2D g_material : register(t1);

uint GetFirstWhite(uint2 pos, uint h)
{
  uint y = pos.y;
  int dist = h - y;
  if (dist <= 0)
    return h;

  for (; y < dist; y++)
  {
    float mat = g_material[int2(pos.x, y)].z;
    //if (mat < 0.5f)
    //  continue;

    float3 color = g_input[int2(pos.x, y)].xyz;
    if (length(color - g_color) >= g_luminance)
      return y;
  }

  return h;
}

uint GetFirstBlack(uint2 pos, uint h)
{
  uint y = pos.y;
  int dist = h - y;
  if (dist <= 0)
    return h;

  //dist = min(dist, 15);
  for (; y < dist; y++)
  {
    float mat = g_material[int2(pos.x, y)].z;
    //if (mat < 0.5f)
    //  return y;

    float3 color = g_input[uint2(pos.x, y)].xyz;
    if (length(color - g_color) <= g_luminance)
      return y;
  }

  return h;
}

RangeColor GetRangeColor(uint2 p0, uint2 p1, uint h)
{
  RangeColor r;
  r.minc = float4(100,100,100,0);
  r.maxc = float4(0,0,0,0);
  r.avgc = float4(0,0,0,0);

  float size = (float)p1.y - (float)p0.y;
  if (size <= 0.0f)
    return r;

  uint2 p;
  for (uint y = p0.y; y < p1.y; ++y)
  {
    p = uint2(p0.x, y);
    float3 c = g_input[p].xyz;
    r.avgc.xyz += c;

    float len = length(c);
    if (len < length(r.minc.xyz))
      r.minc.xyz = c;
    if (len > length(r.maxc.xyz))
      r.maxc.xyz = c;
  }

  r.avgc /= size;

  r.minc.a = (float)p0.y / (float)h;
  r.maxc.a = (float)p1.y / (float)h;

  return r;
}

[numthreads(1, 1, 1)]
void main(uint3 globalID : SV_DispatchThreadID, uint3 localID : SV_GroupThreadID, uint localIndex : SV_GroupIndex, uint3 groupID : SV_GroupID)
{
  uint w, h;
  g_input.GetDimensions(w,h);
  if(globalID.x >= w)
    return;

  uint2 pos = uint2(globalID.x, 0);
  uint first;
  uint next;

  for (int i = 0; i < 16; ++i)
  {
    uint step = 80;

    first = GetFirstWhite(pos, h);
    pos.y = first + 1;
    next = GetFirstBlack(pos, h);

    g_range_buff[globalID.x*16 + i] = GetRangeColor(uint2(pos.x, first), uint2(pos.x, next), h);
    pos.y = min(next+1, h);
  }
}
