org 100h

; first part shamelessly copied from the sizecoding wiki ;)

	push 	0a000h - 70		; modified to center to 160,100
	aas						; aspect ratio constant part
	pop 	es				; get start of video memory in ES
	mov 	al, 0x13		; switch to video mode 13h
	int 	0x10			; 320 * 200 in 256 colors

	; sound
	mov al, 0xff
	out 42h, al	; change divisor of timer2 to 0xFFFF
	out 42h, al	; resulting in a very low frequency
	out 61h, al	; 2 LSBs are set, connect timer to speaker

main:
X:
	mov 	ax,0xCCCD		; perform the famous...
	mul		di				; ... Rrrola trick =)
	sub 	dh,[si]			; align vertically

	pusha
	; bx-4:  ax
	; bx-6:  cx (pixel counter)
	; bx-8:  dx
	; bx-10: bx (0)
	; bx-12: sp
	; bx-14: bp (frame counter)
	; bx-16: si (0x100)
	; bx-18: di (pixel address)

	; X~: -32768..32767
	; Y: -25856..25088
	; AR = [bx+si] = 1.2479 ... * X~
	; X: -40891.2..40889.9
    ; m: 255 [bx-11]
    ; cutoff: ~25000 [byte si+cutoff]
    ; afac: 256/(pi/4) [byte si+afac]

	fild word [bx-9] ; X~
	fmul dword [bx+si] ; X // aspect ratio
	fld st0 ; X X
	fild word [bx-8] ; Y X X
	fpatan ; a~ X
	fimul word [byte si+afac] ; a X
	fxch ; X a
	fmul st0 ; X² a
	fild word [bx-8] ; Y X² a
	fmul st0 ; Y² X² a
	faddp st1, st0 ; Y²+X² a
	fsqrt ; r a
	fild word [byte si+cutoff] ; cutoff r a
	; fcomip st1 ; r a // unsupported by DOSBox dynamic core, 5 bytes lost!
	fcomp st0, st1 ; r a // alternative for DOSBox dynamic core
	fstsw ax ; // alternative for DOSBox dynamic core
	sahf ; // alternative for DOSBox dynamic core
	jb tunnel
	fild word [bx-11] ; m r a
	fdiv st1, st0 ; m r/m a
	fld st2 ; a m r/m a
	fiadd word [bx-14] ; a+t m r/m a
	fprem ; (a+t)%m m r/m a
	fmul st2 ; ((a+t)%m)*r/m m r/m a
	fdivrp st1, st0 ; ((a+t)%m)*r/m/m r/m a
	fstp st2 ; r/m ((a+t)%m)*r/m/m
	jmp done
tunnel:
	fdivr dword [byte si+zoomiep1-1] ; z/r a
	fisub word [bx-14] ; z/r-t a
done:
cutoff:
	fistp word [bx-4] ; u -> ax
	fistp word [bx-8] ; v -> dx
	popa
	ja tunnel2
	and al, 16
tunnel2:
	xor al, dl
	shr al, 3
	add al, 16
done2:
	stosb
	loop X

; shake
	xor byte [si], 1

; increment frame counter
	inc bp

; proper exit with ESC
	in al, 0x60
	dec	al
	jnz main
	out 61h, al ; quiet!
	ret

zoomiep1:
afac:
	dw 326 ; 325.949323452 ; 256/(pi/4)
	db 0x4b ; start IEEE ~8e6 (8e6 = 0x4af42400)
